/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.dao.db.PostgreSQLDB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.util.Map;

public class UpgradePostgreSQL
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        if (DBManagerUtil.getDBType() != DBType.POSTGRESQL) {
            return;
        }
        this.updatePostgreSQLRules(HashMapBuilder.put((Object)"DLContent", (Object)"data_").build());
    }

    protected void updatePostgreSQLRules(Map<String, String> oidColumnNames) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            for (Map.Entry<String, String> entry : oidColumnNames.entrySet()) {
                String tableName = entry.getKey();
                String columnName = entry.getValue();
                PreparedStatement preparedStatement = this.connection.prepareStatement(PostgreSQLDB.getCreateRulesSQL(tableName, columnName));
                try {
                    preparedStatement.executeUpdate();
                }
                finally {
                    if (preparedStatement == null) continue;
                    preparedStatement.close();
                }
            }
        }
    }
}

