/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.counter.kernel.model.Counter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeSocial
extends UpgradeProcess {
    protected void addSocialActivitySets(long delta) throws Exception {
        this.runSQL(StringBundler.concat((Object[])new Object[]{"insert into SocialActivitySet select (activityId + ", delta, ") as activitySetId, groupId, companyId, userId, createDate, ", "createDate AS modifiedDate, classNameId, classPK, type_, ", "extraData, 1 as activityCount from SocialActivity where ", "mirrorActivityId = 0"}));
    }

    protected void deleteOrphanedSocialRequests() throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("delete from SocialRequest where classNameId = ? and classPK not in (select groupId from Group_)");){
            preparedStatement.setLong(1, PortalUtil.getClassNameId((String)"com.liferay.portal.kernel.model.Group"));
            preparedStatement.execute();
        }
    }

    protected void doUpgrade() throws Exception {
        long counterIncrement;
        if (this.getSocialActivitySetsCount() > 0) {
            return;
        }
        long increment = this.increment();
        long delta = this.getDelta(increment);
        this.addSocialActivitySets(delta);
        this.deleteOrphanedSocialRequests();
        this.updateSocialActivities(delta);
        for (counterIncrement = this._getCounterIncrement(); counterIncrement > Integer.MAX_VALUE; counterIncrement -= Integer.MAX_VALUE) {
            this.increment(Counter.class.getName(), Integer.MAX_VALUE);
        }
        if (counterIncrement > 0L) {
            this.increment(Counter.class.getName(), (int)counterIncrement);
        }
    }

    protected long getDelta(long increment) throws Exception {
        try (Statement s = this.connection.createStatement();){
            long l;
            block16: {
                ResultSet resultSet;
                block14: {
                    long l2;
                    block15: {
                        resultSet = s.executeQuery("select min(activityId) from SocialActivity");
                        try {
                            if (!resultSet.next()) break block14;
                            long minActivityId = resultSet.getLong(1);
                            l2 = increment - minActivityId;
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return l2;
                }
                l = 0L;
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return l;
        }
    }

    protected int getSocialActivitySetsCount() throws Exception {
        try (Statement s = this.connection.createStatement();){
            int n;
            block16: {
                ResultSet resultSet;
                block14: {
                    int n2;
                    block15: {
                        String query = "select count(activitySetId) from SocialActivitySet";
                        resultSet = s.executeQuery(query);
                        try {
                            if (!resultSet.next()) break block14;
                            n2 = resultSet.getInt(1);
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return n2;
                }
                n = 0;
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return n;
        }
    }

    protected void updateSocialActivities(long delta) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update SocialActivity set activitySetId = (activityId + ?) where mirrorActivityId = 0");){
            preparedStatement.setLong(1, delta);
            preparedStatement.execute();
        }
    }

    private long _getCounterIncrement() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select currentId from Counter where name = ?");){
            long l;
            block24: {
                ResultSet resultSet;
                block22: {
                    long l2;
                    block23: {
                        preparedStatement1.setString(1, Counter.class.getName());
                        long counter = 0L;
                        try (ResultSet resultSet2 = preparedStatement1.executeQuery();){
                            if (resultSet2.next()) {
                                counter = resultSet2.getLong("currentId");
                            }
                        }
                        PreparedStatement preparedStatement2 = this.connection.prepareStatement("select max(activitySetId) from SocialActivitySet");
                        resultSet = preparedStatement2.executeQuery();
                        try {
                            if (!resultSet.next()) break block22;
                            l2 = Math.max(0L, resultSet.getLong(1) - counter);
                            if (resultSet == null) break block23;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return l2;
                }
                l = 0L;
                if (resultSet == null) break block24;
                resultSet.close();
            }
            return l;
        }
    }
}

