/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_1;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.processor.RawMetadataProcessor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    protected long addRawMetadataProcessorClassName() throws Exception {
        long classNameId = PortalUtil.getClassNameId(RawMetadataProcessor.class);
        if (classNameId != 0L) {
            return classNameId;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("insert into ClassName_ (mvccVersion, classNameId, value) values (?, ?, ?)");){
            classNameId = this.increment();
            preparedStatement.setLong(1, 0L);
            preparedStatement.setLong(2, classNameId);
            preparedStatement.setString(3, RawMetadataProcessor.class.getName());
            preparedStatement.executeUpdate();
        }
        return classNameId;
    }

    protected void doUpgrade() throws Exception {
        this.updateRawMetadataProcessorClassName();
        this.updateTikaRawMetadataDDMStructure();
        this.updateTikaRawMetadataFileEntryMetadata();
    }

    protected long getDDMStructureId(String structureKey, long classNameId) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long l;
            block15: {
                PreparedStatement preparedStatement;
                block13: {
                    long l2;
                    block14: {
                        preparedStatement = this.connection.prepareStatement("select structureId from DDMStructure where structureKey = ? and classNameId = ?");
                        try {
                            preparedStatement.setString(1, structureKey);
                            preparedStatement.setLong(2, classNameId);
                            ResultSet resultSet = preparedStatement.executeQuery();
                            if (!resultSet.next()) break block13;
                            l2 = resultSet.getLong("structureId");
                            if (preparedStatement == null) break block14;
                        }
                        catch (Throwable throwable) {
                            if (preparedStatement != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        preparedStatement.close();
                    }
                    return l2;
                }
                l = 0L;
                if (preparedStatement == null) break block15;
                preparedStatement.close();
            }
            return l;
        }
    }

    protected void updateRawMetadataProcessorClassName() throws Exception {
        long classNameId = PortalUtil.getClassNameId(RawMetadataProcessor.class);
        if (classNameId != 0L) {
            return;
        }
        classNameId = PortalUtil.getClassNameId((String)"com.liferay.document.library.kernel.util.RawMetadataProcessor");
        if (classNameId == 0L) {
            return;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update ClassName_ set value = ? where classNameId = ? ");){
            preparedStatement.setString(1, RawMetadataProcessor.class.getName());
            preparedStatement.setLong(2, classNameId);
            preparedStatement.executeUpdate();
        }
    }

    protected void updateTikaRawMetadataDDMStructure() throws Exception {
        long classNameId = this.addRawMetadataProcessorClassName();
        long ddmStructureId = this.getDDMStructureId("TIKARAWMETADATA", classNameId);
        if (ddmStructureId != 0L) {
            return;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update DDMStructure set classNameId = ? where structureKey = ?");){
            preparedStatement.setLong(1, classNameId);
            preparedStatement.setString(2, "TIKARAWMETADATA");
            preparedStatement.execute();
        }
    }

    protected void updateTikaRawMetadataFileEntryMetadata() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long oldDDMStructureId = this.getDDMStructureId("TIKARAWMETADATA", PortalUtil.getClassNameId(DLFileEntry.class));
            if (oldDDMStructureId == 0L) {
                return;
            }
            long newDDMStructureId = this.getDDMStructureId("TIKARAWMETADATA", PortalUtil.getClassNameId(RawMetadataProcessor.class));
            if (newDDMStructureId == 0L) {
                return;
            }
            try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select fileVersionId, DDMStructureId from ", "DLFileEntryMetadata where fileVersionId in ", "(select fileVersionId from DLFileEntryMetadata ", "group by fileVersionId having count(*) >= 2) and ", "DDMStructureId = ?"}));
                 PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"delete from DLFileEntryMetadata where fileVersionId = ? and DDMStructureId = ?");){
                preparedStatement1.setLong(1, oldDDMStructureId);
                ResultSet resultSet = preparedStatement1.executeQuery();
                while (resultSet.next()) {
                    long fileVersionId = resultSet.getLong("fileVersionId");
                    long ddmStructureId = resultSet.getLong("DDMStructureId");
                    preparedStatement2.setLong(1, fileVersionId);
                    preparedStatement2.setLong(2, ddmStructureId);
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("update DLFileEntryMetadata set DDMStructureId = ? where DDMStructureId = ?");){
                preparedStatement.setLong(1, newDDMStructureId);
                preparedStatement.setLong(2, oldDDMStructureId);
                preparedStatement.execute();
            }
        }
    }
}

