/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_5;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class UpgradePortalPreferences
extends UpgradeProcess {
    private static final String[] _OBSOLETE_PORTAL_PREFERENCES = new String[]{"auto.deploy.custom.portlet.xml", "auto.deploy.deploy.dir", "auto.deploy.dest.dir", "auto.deploy.enabled", "auto.deploy.interval", "auto.deploy.jboss.prefix", "auto.deploy.tomcat.conf.dir", "auto.deploy.tomcat.lib.dir", "auto.deploy.unpack.war", "plugin.notifications.enabled", "plugin.notifications.packages.ignored", "plugin.repositories.trusted", "plugin.repositories.untrusted"};
    private static final Log _log = LogFactoryUtil.getLog(UpgradePortalPreferences.class);

    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.upgradePortalPreferences(0L);
            for (long companyId : PortalInstancePool.getCompanyIds()) {
                this.upgradePortalPreferences(companyId);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void upgradePortalPreferences(long companyId) throws Exception {
        String sql = StringBundler.concat((Object[])new Object[]{"select portalPreferencesId, preferences from PortalPreferences ", "where ownerId = ", companyId, " and ownerType = ", 1});
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(sql);
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                String preferences = resultSet.getString("preferences");
                Document document = SAXReaderUtil.read((String)preferences);
                Element portletPreferencesElement = document.getRootElement();
                boolean updatedDocument = false;
                for (String obsoletePortalPreference : _OBSOLETE_PORTAL_PREFERENCES) {
                    XPath xPath = SAXReaderUtil.createXPath((String)("/portlet-preferences/preference[name='" + obsoletePortalPreference + "']"));
                    List nodes = xPath.selectNodes((Object)document);
                    for (Node node : nodes) {
                        Element element = (Element)node;
                        if (_log.isWarnEnabled()) {
                            Element valueElement = element.element("value");
                            String value = valueElement.getStringValue();
                            _log.warn((Object)StringBundler.concat((String[])new String[]{"Detected a value of \"", value, "\" for portal property ", obsoletePortalPreference, " stored in portal preferences. Storing ", "this property in portal preferences is ", "no longer supported; please set this ", "property to this value in ", "portal-ext.properties if you wish to ", "retain it."}));
                        }
                        portletPreferencesElement.remove(element);
                        updatedDocument = true;
                    }
                }
                if (!updatedDocument) continue;
                PreparedStatement preparedStatement2 = this.connection.prepareStatement("update PortalPreferences set preferences = ? where portalPreferencesId = ?");
                try {
                    preparedStatement2.setString(1, document.asXML());
                    preparedStatement2.setLong(2, resultSet.getLong("portalPreferencesId"));
                    preparedStatement2.executeUpdate();
                }
                finally {
                    if (preparedStatement2 == null) continue;
                    preparedStatement2.close();
                }
            }
            return;
        }
    }
}

