/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.PortalPreferenceValue;
import com.liferay.portal.kernel.model.PortalPreferences;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.service.PortalPreferenceValueLocalService;
import com.liferay.portal.kernel.service.PortalPreferencesLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.PortalPreferencesImpl;
import com.liferay.portlet.PortalPreferencesWrapper;
import com.liferay.portlet.PortletPreferencesImpl;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class PrefsPropsImpl
implements PrefsProps {
    private static final Log _log = LogFactoryUtil.getLog(PrefsPropsImpl.class);
    private static final Map<Long, PortletPreferences> _portletPreferences = new ConcurrentHashMap<Long, PortletPreferences>();
    private static final MethodKey _removePortletPreferenceMethodKey = new MethodKey(PrefsPropsImpl.class, "_removePortletPreference", new Class[]{Long.TYPE});
    private static final ThreadLocal<Boolean> _skipCacheThreadLocal = ThreadLocal.withInitial(() -> false);
    private final PortletPreferences _emptyPortletPreferences = new PortletPreferencesImpl();
    @BeanReference(type=PortalPreferencesLocalService.class)
    private PortalPreferencesLocalService _portalPreferencesLocalService;
    @BeanReference(type=PortalPreferenceValueLocalService.class)
    private PortalPreferenceValueLocalService _portalPreferenceValueLocalService;
    private ServiceRegistration<?> _serviceRegistration;

    public void afterPropertiesSet() {
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        this._serviceRegistration = bundleContext.registerService(ModelListener.class, (Object)new PortalPreferenceValueModelListener(), null);
    }

    public void destroy() {
        this._serviceRegistration.unregister();
    }

    public boolean getBoolean(long companyId, String name) {
        return this.getBoolean(this._fetchPreferences(companyId), name);
    }

    public boolean getBoolean(long companyId, String name, boolean defaultValue) {
        return this.getBoolean(this._fetchPreferences(companyId), name, defaultValue);
    }

    public boolean getBoolean(PortletPreferences portletPreferences, String name) {
        return GetterUtil.getBoolean((String)this.getString(portletPreferences, name));
    }

    public boolean getBoolean(PortletPreferences portletPreferences, String name, boolean defaultValue) {
        return GetterUtil.getBoolean((String)this.getString(portletPreferences, name, defaultValue));
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(this._fetchPreferences(), name);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.getBoolean(this._fetchPreferences(), name, defaultValue);
    }

    public String getContent(long companyId, String name) {
        return this.getContent(this._fetchPreferences(companyId), name);
    }

    public String getContent(PortletPreferences portletPreferences, String name) {
        String value = portletPreferences.getValue(name, "");
        if (Validator.isNotNull((String)value)) {
            return value;
        }
        try {
            return StringUtil.read((ClassLoader)PrefsPropsImpl.class.getClassLoader(), (String)PropsUtil.get(name));
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to read the content for " + PropsUtil.get(name)), (Throwable)ioException);
            return null;
        }
    }

    public String getContent(String name) {
        return this.getContent(this._fetchPreferences(), name);
    }

    public double getDouble(long companyId, String name) {
        return this.getDouble(this._fetchPreferences(companyId), name);
    }

    public double getDouble(long companyId, String name, double defaultValue) {
        return this.getDouble(this._fetchPreferences(companyId), name, defaultValue);
    }

    public double getDouble(PortletPreferences portletPreferences, String name) {
        return GetterUtil.getDouble((String)this.getString(portletPreferences, name));
    }

    public double getDouble(PortletPreferences portletPreferences, String name, double defaultValue) {
        return GetterUtil.getDouble((String)this.getString(portletPreferences, name, defaultValue));
    }

    public double getDouble(String name) {
        return this.getDouble(this._fetchPreferences(), name);
    }

    public double getDouble(String name, double defaultValue) {
        return this.getDouble(this._fetchPreferences(), name, defaultValue);
    }

    public int getInteger(long companyId, String name) {
        return this.getInteger(this._fetchPreferences(companyId), name);
    }

    public int getInteger(long companyId, String name, int defaultValue) {
        return this.getInteger(this._fetchPreferences(companyId), name, defaultValue);
    }

    public int getInteger(PortletPreferences portletPreferences, String name) {
        return GetterUtil.getInteger((String)this.getString(portletPreferences, name));
    }

    public int getInteger(PortletPreferences portletPreferences, String name, int defaultValue) {
        return GetterUtil.getInteger((String)this.getString(portletPreferences, name, defaultValue));
    }

    public int getInteger(String name) {
        return this.getInteger(this._fetchPreferences(), name);
    }

    public int getInteger(String name, int defaultValue) {
        return this.getInteger(this._fetchPreferences(), name, defaultValue);
    }

    public long getLong(long companyId, String name) {
        return this.getLong(this._fetchPreferences(companyId), name);
    }

    public long getLong(long companyId, String name, long defaultValue) {
        return this.getLong(this._fetchPreferences(companyId), name, defaultValue);
    }

    public long getLong(PortletPreferences portletPreferences, String name) {
        return GetterUtil.getLong((String)this.getString(portletPreferences, name));
    }

    public long getLong(PortletPreferences portletPreferences, String name, long defaultValue) {
        return GetterUtil.getLong((String)this.getString(portletPreferences, name, defaultValue));
    }

    public long getLong(String name) {
        return this.getLong(this._fetchPreferences(), name);
    }

    public long getLong(String name, long defaultValue) {
        return this.getLong(this._fetchPreferences(), name, defaultValue);
    }

    public PortletPreferences getPreferences() {
        return this.getPreferences(0L);
    }

    public PortletPreferences getPreferences(long companyId) {
        PortletPreferences portletPreferences = this._fetchPreferences(companyId);
        if (portletPreferences == this._emptyPortletPreferences) {
            return new LazyPortletPreferences(this._emptyPortletPreferences, () -> this._portalPreferencesLocalService.getPreferences(companyId, 1));
        }
        PortalPreferencesWrapper portalPreferencesWrapper = (PortalPreferencesWrapper)portletPreferences;
        return portalPreferencesWrapper.clone();
    }

    public Properties getProperties(PortletPreferences portletPreferences, String prefix, boolean removePrefix) {
        Properties newProperties = new Properties();
        Enumeration enumeration = portletPreferences.getNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith(prefix)) continue;
            String value = portletPreferences.getValue(key, "");
            if (removePrefix) {
                key = key.substring(prefix.length());
            }
            newProperties.setProperty(key, value);
        }
        return newProperties;
    }

    public Properties getProperties(String prefix, boolean removePrefix) {
        return this.getProperties(this._fetchPreferences(), prefix, removePrefix);
    }

    public short getShort(long companyId, String name) {
        return this.getShort(this._fetchPreferences(companyId), name);
    }

    public short getShort(long companyId, String name, short defaultValue) {
        return this.getShort(this._fetchPreferences(companyId), name, defaultValue);
    }

    public short getShort(PortletPreferences portletPreferences, String name) {
        return GetterUtil.getShort((String)this.getString(portletPreferences, name));
    }

    public short getShort(PortletPreferences portletPreferences, String name, short defaultValue) {
        return GetterUtil.getShort((String)this.getString(portletPreferences, name, defaultValue));
    }

    public short getShort(String name) {
        return this.getShort(this._fetchPreferences(), name);
    }

    public short getShort(String name, short defaultValue) {
        return this.getShort(this._fetchPreferences(), name, defaultValue);
    }

    public String getString(long companyId, String name) {
        return this.getString(this._fetchPreferences(companyId), name);
    }

    public String getString(long companyId, String name, String defaultValue) {
        return this.getString(this._fetchPreferences(companyId), name, defaultValue);
    }

    public String getString(PortletPreferences portletPreferences, String name) {
        String value = PropsUtil.get(name);
        return portletPreferences.getValue(name, value);
    }

    public String getString(PortletPreferences portletPreferences, String name, boolean defaultValue) {
        return portletPreferences.getValue(name, String.valueOf(defaultValue));
    }

    public String getString(PortletPreferences portletPreferences, String name, double defaultValue) {
        return portletPreferences.getValue(name, String.valueOf(defaultValue));
    }

    public String getString(PortletPreferences portletPreferences, String name, int defaultValue) {
        return portletPreferences.getValue(name, String.valueOf(defaultValue));
    }

    public String getString(PortletPreferences portletPreferences, String name, long defaultValue) {
        return portletPreferences.getValue(name, String.valueOf(defaultValue));
    }

    public String getString(PortletPreferences portletPreferences, String name, short defaultValue) {
        return portletPreferences.getValue(name, String.valueOf(defaultValue));
    }

    public String getString(PortletPreferences portletPreferences, String name, String defaultValue) {
        return portletPreferences.getValue(name, defaultValue);
    }

    public String getString(String name) {
        return this.getString(this._fetchPreferences(), name);
    }

    public String getString(String name, String defaultValue) {
        return this.getString(this._fetchPreferences(), name, defaultValue);
    }

    public String[] getStringArray(long companyId, String name, String delimiter) {
        return this.getStringArray(this._fetchPreferences(companyId), name, delimiter);
    }

    public String[] getStringArray(long companyId, String name, String delimiter, String[] defaultValue) {
        return this.getStringArray(this._fetchPreferences(companyId), name, delimiter, defaultValue);
    }

    public String[] getStringArray(PortletPreferences portletPreferences, String name, String delimiter) {
        String value = PropsUtil.get(name);
        return StringUtil.split((String)portletPreferences.getValue(name, value), (String)delimiter);
    }

    public String[] getStringArray(PortletPreferences portletPreferences, String name, String delimiter, String[] defaultValue) {
        String value = portletPreferences.getValue(name, null);
        if (value == null) {
            return defaultValue;
        }
        return StringUtil.split((String)value, (String)delimiter);
    }

    public String[] getStringArray(String name, String delimiter) {
        return this.getStringArray(this._fetchPreferences(), name, delimiter);
    }

    public String[] getStringArray(String name, String delimiter, String[] defaultValue) {
        return this.getStringArray(this._fetchPreferences(), name, delimiter, defaultValue);
    }

    public String getStringFromNames(long companyId, String ... names) {
        for (String name : names) {
            String value = this.getString(companyId, name);
            if (!Validator.isNotNull((String)value)) continue;
            return value;
        }
        return null;
    }

    private static void _removePortletPreference(long companyId) {
        _portletPreferences.remove(companyId);
        if (ClusterExecutorUtil.isEnabled() && ClusterInvokeThreadLocal.isEnabled()) {
            ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)new MethodHandler(_removePortletPreferenceMethodKey, new Object[]{companyId}), (boolean)true);
            clusterRequest.setFireAndForget(true);
            ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        }
    }

    private PortletPreferences _fetchPreferences() {
        return this._fetchPreferences(0L);
    }

    private PortletPreferences _fetchPreferences(long companyId) {
        if (_skipCacheThreadLocal.get().booleanValue()) {
            return this._getPortletPreferences(companyId);
        }
        return _portletPreferences.computeIfAbsent(companyId, this::_getPortletPreferences);
    }

    private PortletPreferences _getPortletPreferences(long companyId) {
        PortalPreferences portalPreferences = this._portalPreferencesLocalService.fetchPortalPreferences(companyId, 1);
        if (portalPreferences == null) {
            return this._emptyPortletPreferences;
        }
        PortalPreferencesImpl portalPreferencesImpl = (PortalPreferencesImpl)this._portalPreferenceValueLocalService.getPortalPreferences(portalPreferences, false);
        return new PortalPreferencesWrapper(portalPreferencesImpl);
    }

    private class PortalPreferenceValueModelListener
    extends BaseModelListener<PortalPreferenceValue> {
        private PortalPreferenceValueModelListener() {
        }

        public Class<?> getModelClass() {
            return PortalPreferenceValue.class;
        }

        public void onBeforeCreate(PortalPreferenceValue portalPreferenceValue) throws ModelListenerException {
            this._clearPortletPreferencce(portalPreferenceValue);
        }

        public void onBeforeRemove(PortalPreferenceValue portalPreferenceValue) throws ModelListenerException {
            this._clearPortletPreferencce(portalPreferenceValue);
        }

        public void onBeforeUpdate(PortalPreferenceValue originalPortalPreferenceValue, PortalPreferenceValue portalPreferenceValue) {
            this._clearPortletPreferencce(portalPreferenceValue);
        }

        private void _clearPortletPreferencce(PortalPreferenceValue portalPreferenceValue) {
            if (_skipCacheThreadLocal.get().booleanValue()) {
                return;
            }
            try {
                PortalPreferences portalPreferences = PrefsPropsImpl.this._portalPreferencesLocalService.getPortalPreferences(portalPreferenceValue.getPortalPreferencesId());
                if (portalPreferences.getOwnerType() == 1) {
                    _skipCacheThreadLocal.set(true);
                    TransactionCommitCallbackUtil.registerCallback(() -> {
                        PrefsPropsImpl._removePortletPreference(portalPreferenceValue.getCompanyId());
                        _skipCacheThreadLocal.set(false);
                        return null;
                    });
                }
            }
            catch (PortalException portalException) {
                throw new ModelListenerException((Throwable)portalException);
            }
        }
    }

    private static class LazyPortletPreferences
    implements PortletPreferences {
        private boolean _loaded;
        private PortletPreferences _portletPreferences;
        private final Supplier<PortletPreferences> _writePortletPreferencesSupplier;

        public Map<String, String[]> getMap() {
            return this._portletPreferences.getMap();
        }

        public Enumeration<String> getNames() {
            return this._portletPreferences.getNames();
        }

        public String getValue(String key, String def) {
            return this._portletPreferences.getValue(key, def);
        }

        public String[] getValues(String key, String[] def) {
            return this._portletPreferences.getValues(key, def);
        }

        public boolean isReadOnly(String key) {
            return this._portletPreferences.isReadOnly(key);
        }

        public void reset(String key) throws ReadOnlyException {
            this._ensureLoaded();
            this._portletPreferences.reset(key);
        }

        public void setValue(String key, String value) throws ReadOnlyException {
            this._ensureLoaded();
            this._portletPreferences.setValue(key, value);
        }

        public void setValues(String key, String ... values) throws ReadOnlyException {
            this._ensureLoaded();
            this._portletPreferences.setValues(key, values);
        }

        public void store() throws IOException, ValidatorException {
            this._ensureLoaded();
            this._portletPreferences.store();
        }

        private LazyPortletPreferences(PortletPreferences portletPreferences, Supplier<PortletPreferences> writePortletPreferencesSupplier) {
            this._portletPreferences = portletPreferences;
            this._writePortletPreferencesSupplier = writePortletPreferencesSupplier;
        }

        private void _ensureLoaded() {
            if (!this._loaded) {
                this._portletPreferences = this._writePortletPreferencesSupplier.get();
                this._loaded = true;
            }
        }
    }
}

