/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.verify.model.VerifiableAuditedModel;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portal.verify.model.LayoutFriendlyURLVerifiableAuditedModel;
import com.liferay.portal.verify.model.LayoutPrototypeVerifiableModel;
import com.liferay.portal.verify.model.LayoutSetPrototypeVerifiableModel;
import com.liferay.portal.verify.model.LayoutVerifiableAuditedModel;
import com.liferay.portal.verify.model.OrganizationVerifiableModel;
import com.liferay.portal.verify.model.RepositoryEntryVerifiableAuditedModel;
import com.liferay.portal.verify.model.RoleVerifiableModel;
import com.liferay.portal.verify.model.UserGroupVerifiableModel;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class VerifyAuditedModel
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyAuditedModel.class);

    public void verify(VerifiableAuditedModel ... verifiableAuditedModels) throws Exception {
        ArrayList<String> unverifiedTableNames = new ArrayList<String>();
        for (VerifiableAuditedModel verifiableAuditedModel : verifiableAuditedModels) {
            unverifiedTableNames.add(verifiableAuditedModel.getTableName());
        }
        ArrayList<VerifyAuditedModelCallable> verifyAuditedModelCallables = new ArrayList<VerifyAuditedModelCallable>(unverifiedTableNames.size());
        while (!unverifiedTableNames.isEmpty()) {
            int count = unverifiedTableNames.size();
            for (VerifiableAuditedModel verifiableAuditedModel : verifiableAuditedModels) {
                if (unverifiedTableNames.contains(verifiableAuditedModel.getJoinByTableName()) || !unverifiedTableNames.contains(verifiableAuditedModel.getTableName())) continue;
                VerifyAuditedModelCallable verifyAuditedModelCallable = new VerifyAuditedModelCallable(verifiableAuditedModel);
                verifyAuditedModelCallables.add(verifyAuditedModelCallable);
                unverifiedTableNames.remove(verifiableAuditedModel.getTableName());
            }
            if (unverifiedTableNames.size() != count) continue;
            throw new VerifyException("Circular dependency detected " + unverifiedTableNames);
        }
        this.doVerify(verifyAuditedModelCallables);
    }

    @Override
    protected void doVerify() throws Exception {
        this.verify(new LayoutFriendlyURLVerifiableAuditedModel(), new LayoutPrototypeVerifiableModel(), new LayoutSetPrototypeVerifiableModel(), new LayoutVerifiableAuditedModel(), new OrganizationVerifiableModel(), new RepositoryEntryVerifiableAuditedModel(), new RoleVerifiableModel(), new UserGroupVerifiableModel());
    }

    protected Object[] getAuditedModelArray(Connection connection, String tableName, String pkColumnName, long primKey, boolean allowAnonymousUser, long previousUserId) throws Exception {
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((String[])new String[]{"select companyId, userId, createDate, modifiedDate from ", tableName, " where ", pkColumnName, " = ?"}));){
            Object[] objectArray;
            block19: {
                ResultSet resultSet;
                block17: {
                    Object[] objectArray2;
                    block18: {
                        preparedStatement.setLong(1, primKey);
                        resultSet = preparedStatement.executeQuery();
                        try {
                            if (!resultSet.next()) break block17;
                            long companyId = resultSet.getLong("companyId");
                            long userId = 0L;
                            String userName = null;
                            if (allowAnonymousUser) {
                                userId = previousUserId;
                                userName = "Anonymous";
                            } else {
                                userId = resultSet.getLong("userId");
                                userName = this.getUserName(connection, userId);
                            }
                            Timestamp createDate = resultSet.getTimestamp("createDate");
                            Timestamp modifiedDate = resultSet.getTimestamp("modifiedDate");
                            objectArray2 = new Object[]{companyId, userId, userName, createDate, modifiedDate};
                            if (resultSet == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return objectArray2;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Unable to find ", tableName, " ", String.valueOf(primKey)}));
                }
                objectArray = null;
                if (resultSet == null) break block19;
                resultSet.close();
            }
            return objectArray;
        }
    }

    protected Object[] getGuestUserArray(Connection connection, long companyId) throws Exception {
        try (PreparedStatement preparedStatement = connection.prepareStatement("select userId, firstName, middleName, lastName from User_ where companyId = ? and type_ = ?");){
            Object[] objectArray;
            block16: {
                ResultSet resultSet;
                block14: {
                    Object[] objectArray2;
                    block15: {
                        preparedStatement.setLong(1, companyId);
                        preparedStatement.setInt(2, 0);
                        resultSet = preparedStatement.executeQuery();
                        try {
                            if (!resultSet.next()) break block14;
                            long userId = resultSet.getLong("userId");
                            String firstName = resultSet.getString("firstName");
                            String middleName = resultSet.getString("middleName");
                            String lastName = resultSet.getString("lastName");
                            FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
                            String userName = fullNameGenerator.getFullName(firstName, middleName, lastName);
                            Timestamp createDate = new Timestamp(System.currentTimeMillis());
                            objectArray2 = new Object[]{companyId, userId, userName, createDate, createDate};
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return objectArray2;
                }
                objectArray = null;
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return objectArray;
        }
    }

    protected String getUserName(Connection connection, long userId) throws Exception {
        try (PreparedStatement preparedStatement = connection.prepareStatement("select firstName, middleName, lastName from User_ where userId = ?");){
            String string;
            block16: {
                ResultSet resultSet;
                block14: {
                    String string2;
                    block15: {
                        preparedStatement.setLong(1, userId);
                        resultSet = preparedStatement.executeQuery();
                        try {
                            if (!resultSet.next()) break block14;
                            String firstName = resultSet.getString("firstName");
                            String middleName = resultSet.getString("middleName");
                            String lastName = resultSet.getString("lastName");
                            FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
                            string2 = fullNameGenerator.getFullName(firstName, middleName, lastName);
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return string2;
                }
                string = "";
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return string;
        }
    }

    protected void verifyAuditedModel(Connection connection, PreparedStatement preparedStatement, String tableName, long primKey, Object[] auditedModelArray, boolean updateDates) throws Exception {
        block5: {
            try {
                long companyId = (Long)auditedModelArray[0];
                if (auditedModelArray[2] == null && (auditedModelArray = this.getGuestUserArray(connection, companyId)) == null) {
                    return;
                }
                long userId = (Long)auditedModelArray[1];
                String userName = (String)auditedModelArray[2];
                preparedStatement.setLong(1, companyId);
                preparedStatement.setLong(2, userId);
                preparedStatement.setString(3, userName);
                if (updateDates) {
                    Timestamp createDate = (Timestamp)auditedModelArray[3];
                    preparedStatement.setTimestamp(4, createDate);
                    Timestamp modifiedDate = (Timestamp)auditedModelArray[4];
                    preparedStatement.setTimestamp(5, modifiedDate);
                    preparedStatement.setLong(6, primKey);
                } else {
                    preparedStatement.setLong(4, primKey);
                }
                preparedStatement.addBatch();
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)("Unable to verify model " + tableName), (Throwable)exception);
            }
        }
    }

    protected void verifyAuditedModel(VerifiableAuditedModel verifiableAuditedModel) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(verifiableAuditedModel.getTableName());){
            StringBundler sb = new StringBundler(8);
            sb.append("select ");
            sb.append(verifiableAuditedModel.getPrimaryKeyColumnName());
            sb.append(", companyId, userId");
            if (verifiableAuditedModel.getJoinByTableName() != null) {
                sb.append(", ");
                sb.append(verifiableAuditedModel.getJoinByTableName());
            }
            sb.append(" from ");
            sb.append(verifiableAuditedModel.getTableName());
            sb.append(" where userName is null order by companyId");
            Object[] auditedModelArray = null;
            long previousCompanyId = 0L;
            try (Connection connection = DataAccess.getConnection();
                 PreparedStatement preparedStatement1 = connection.prepareStatement(sb.toString());
                 ResultSet resultSet = preparedStatement1.executeQuery();
                 PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)connection, (String)this._getSQL(verifiableAuditedModel.getTableName(), verifiableAuditedModel.getPrimaryKeyColumnName(), verifiableAuditedModel.isUpdateDates()));){
                while (resultSet.next()) {
                    long companyId = resultSet.getLong("companyId");
                    if (verifiableAuditedModel.getJoinByTableName() != null) {
                        long previousUserId = resultSet.getLong("userId");
                        long relatedPrimKey = resultSet.getLong(verifiableAuditedModel.getJoinByTableName());
                        auditedModelArray = this.getAuditedModelArray(connection, verifiableAuditedModel.getRelatedModelName(), verifiableAuditedModel.getRelatedPKColumnName(), relatedPrimKey, verifiableAuditedModel.isAnonymousUserAllowed(), previousUserId);
                    } else if (previousCompanyId != companyId) {
                        auditedModelArray = this.getGuestUserArray(connection, companyId);
                        previousCompanyId = companyId;
                    }
                    if (auditedModelArray == null) continue;
                    long primKey = resultSet.getLong(verifiableAuditedModel.getPrimaryKeyColumnName());
                    this.verifyAuditedModel(connection, preparedStatement2, verifiableAuditedModel.getTableName(), primKey, auditedModelArray, verifiableAuditedModel.isUpdateDates());
                }
                preparedStatement2.executeBatch();
            }
        }
    }

    private String _getSQL(String tableName, String primaryKeyColumnName, boolean updateDates) {
        StringBundler sb = new StringBundler(7);
        sb.append("update ");
        sb.append(tableName);
        sb.append(" set companyId = ?, userId = ?, userName = ?");
        if (updateDates) {
            sb.append(", createDate = ?, modifiedDate = ?");
        }
        sb.append(" where ");
        sb.append(primaryKeyColumnName);
        sb.append(" = ?");
        return sb.toString();
    }

    private class VerifyAuditedModelCallable
    implements Callable<Void> {
        private final VerifiableAuditedModel _verifiableAuditedModel;

        @Override
        public Void call() throws Exception {
            VerifyAuditedModel.this.verifyAuditedModel(this._verifiableAuditedModel);
            return null;
        }

        private VerifyAuditedModelCallable(VerifiableAuditedModel verifiableAuditedModel) {
            this._verifiableAuditedModel = verifiableAuditedModel;
        }
    }
}

