/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.verify.model.VerifiableGroupedModel;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;

public class VerifyGroupedModel
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyGroupedModel.class);

    public void verify(VerifiableGroupedModel ... verifiableGroupedModels) throws Exception {
        ArrayList<String> unverifiedTableNames = new ArrayList<String>();
        for (VerifiableGroupedModel verifiableGroupedModel2 : verifiableGroupedModels) {
            unverifiedTableNames.add(verifiableGroupedModel2.getTableName());
        }
        if (unverifiedTableNames.isEmpty()) {
            return;
        }
        int count = unverifiedTableNames.size();
        this.processConcurrently(verifiableGroupedModels, verifiableGroupedModel -> {
            if (unverifiedTableNames.contains(verifiableGroupedModel.getRelatedTableName()) || !unverifiedTableNames.contains(verifiableGroupedModel.getTableName())) {
                return;
            }
            unverifiedTableNames.remove(verifiableGroupedModel.getTableName());
            if (unverifiedTableNames.size() == count) {
                throw new VerifyException("Circular dependency detected " + unverifiedTableNames);
            }
            this.verifyGroupedModel((VerifiableGroupedModel)verifiableGroupedModel);
        }, null);
    }

    @Override
    protected void doVerify() throws Exception {
        Map verifiableGroupedModelsMap = PortalBeanLocatorUtil.locate(VerifiableGroupedModel.class);
        Collection verifiableGroupedModels = verifiableGroupedModelsMap.values();
        this.verify(verifiableGroupedModels.toArray(new VerifiableGroupedModel[0]));
    }

    protected long getGroupId(Connection connection, String tableName, String primaryKeColumnName, long primKey) throws Exception {
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((String[])new String[]{"select groupId from ", tableName, " where ", primaryKeColumnName, " = ?"}));){
            long l;
            block17: {
                ResultSet resultSet;
                block15: {
                    long l2;
                    block16: {
                        preparedStatement.setLong(1, primKey);
                        resultSet = preparedStatement.executeQuery();
                        try {
                            if (!resultSet.next()) break block15;
                            l2 = resultSet.getLong("groupId");
                            if (resultSet == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return l2;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to find ", tableName, " ", primKey}));
                }
                l = 0L;
                if (resultSet == null) break block17;
                resultSet.close();
            }
            return l;
        }
    }

    @Override
    protected boolean isForceConcurrent(Collection<? extends Callable<Void>> callables) {
        return true;
    }

    protected void verifyGroupedModel(VerifiableGroupedModel verifiableGroupedModel) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(verifiableGroupedModel.getTableName());
             Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement1 = connection.prepareStatement(StringBundler.concat((String[])new String[]{"select ", verifiableGroupedModel.getPrimaryKeyColumnName(), ", ", verifiableGroupedModel.getRelatedPrimaryKeyColumnName(), " from ", verifiableGroupedModel.getTableName(), " where groupId is null"}));
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)connection, (String)StringBundler.concat((String[])new String[]{"update ", verifiableGroupedModel.getTableName(), " set groupId = ? where ", verifiableGroupedModel.getPrimaryKeyColumnName(), " = ?"}));){
            while (resultSet.next()) {
                long relatedPrimKey = resultSet.getLong(verifiableGroupedModel.getRelatedPrimaryKeyColumnName());
                long groupId = this.getGroupId(connection, verifiableGroupedModel.getRelatedTableName(), verifiableGroupedModel.getRelatedPrimaryKeyColumnName(), relatedPrimKey);
                if (groupId <= 0L) continue;
                preparedStatement2.setLong(1, groupId);
                long primKey = resultSet.getLong(verifiableGroupedModel.getPrimaryKeyColumnName());
                preparedStatement2.setLong(2, primKey);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

