/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.kernel.verify.model.VerifiableUUIDModel;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class VerifyUUID
extends VerifyProcess {
    private static VerifiableUUIDModel[] _verifiableUUIDModels;

    public static void verify(VerifiableUUIDModel ... verifiableUUIDModels) throws Exception {
        VerifyUUID verifyUUID = new VerifyUUID();
        _verifiableUUIDModels = verifiableUUIDModels;
        verifyUUID.verify();
    }

    @Override
    protected void doVerify() throws Exception {
        if (ArrayUtil.isNotEmpty((Object[])_verifiableUUIDModels)) {
            this.doVerify(_verifiableUUIDModels);
        }
    }

    protected void doVerify(VerifiableUUIDModel ... verifiableUUIDModels) throws Exception {
        this.processConcurrently(verifiableUUIDModels, this::verifyUUID, null);
    }

    protected void verifyUUID(VerifiableUUIDModel verifiableUUIDModel) throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.isSupportsNewUuidFunction()) {
            try (LoggingTimer loggingTimer = new LoggingTimer(verifiableUUIDModel.getTableName());){
                block36: {
                    PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"update ", verifiableUUIDModel.getTableName(), " set uuid_ = ", db.getNewUuidFunctionName(), " where uuid_ is null or uuid_ = ''"}));
                    try {
                        preparedStatement.executeUpdate();
                        if (preparedStatement == null) break block36;
                    }
                    catch (Throwable throwable) {
                        if (preparedStatement != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    preparedStatement.close();
                }
                return;
            }
        }
        try (LoggingTimer loggingTimer = new LoggingTimer(verifiableUUIDModel.getTableName());
             PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select ", verifiableUUIDModel.getPrimaryKeyColumnName(), " from ", verifiableUUIDModel.getTableName(), " where uuid_ is null or uuid_ = ''"}));
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"update ", verifiableUUIDModel.getTableName(), " set uuid_ = ? where ", verifiableUUIDModel.getPrimaryKeyColumnName(), " = ?"}));){
            while (resultSet.next()) {
                long pk = resultSet.getLong(verifiableUUIDModel.getPrimaryKeyColumnName());
                preparedStatement2.setString(1, PortalUUIDUtil.generate());
                preparedStatement2.setLong(2, pk);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

