/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.NoSuchLockException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.Status;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.webdav.methods.Method;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LockMethodImpl
implements Method {
    private static final Log _log = LogFactoryUtil.getLog(LockMethodImpl.class);

    public int process(WebDAVRequest webDAVRequest) throws WebDAVException {
        try {
            return this.doProcess(webDAVRequest);
        }
        catch (Exception exception) {
            throw new WebDAVException((Throwable)exception);
        }
    }

    protected int doProcess(WebDAVRequest webDAVRequest) throws Exception {
        Status status;
        block18: {
            WebDAVStorage storage = webDAVRequest.getWebDAVStorage();
            if (!storage.isSupportsClassTwo()) {
                return 405;
            }
            HttpServletRequest httpServletRequest = webDAVRequest.getHttpServletRequest();
            Lock lock = null;
            status = null;
            String lockUuid = webDAVRequest.getLockUuid();
            long timeout = WebDAVUtil.getTimeout((HttpServletRequest)httpServletRequest);
            if (Validator.isNull((String)lockUuid)) {
                Object owner = null;
                String xml = new String(FileUtil.getBytes((InputStream)httpServletRequest.getInputStream()));
                if (Validator.isNotNull((String)xml)) {
                    Document document = SAXReaderUtil.read((String)xml);
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Request XML\n" + document.formattedString()));
                    }
                    Element rootElement = document.getRootElement();
                    boolean exclusive = false;
                    Element lockscopeElement = rootElement.element("lockscope");
                    for (Element element : lockscopeElement.elements()) {
                        String name = GetterUtil.getString((String)element.getName());
                        if (!name.equals("exclusive")) continue;
                        exclusive = true;
                    }
                    if (!exclusive) {
                        return 400;
                    }
                    Element ownerElement = rootElement.element("owner");
                    owner = ownerElement.getTextTrim();
                    if (Validator.isNull((String)owner)) {
                        List hrefElements = ownerElement.elements("href");
                        for (Element hrefElement : hrefElements) {
                            owner = "<D:href>" + hrefElement.getTextTrim() + "</D:href>";
                        }
                    }
                } else {
                    _log.error((Object)"Empty request XML");
                    return 412;
                }
                status = storage.lockResource(webDAVRequest, (String)owner, timeout);
                lock = (Lock)status.getObject();
            } else {
                try {
                    lock = storage.refreshResourceLock(webDAVRequest, lockUuid, timeout);
                    status = new Status(200);
                }
                catch (WebDAVException webDAVException) {
                    if (webDAVException.getCause() instanceof NoSuchLockException) {
                        return 412;
                    }
                    throw webDAVException;
                }
            }
            if (lock == null) {
                return status.getCode();
            }
            String xml = this.getResponseXML(lock, WebDAVUtil.getDepth((HttpServletRequest)httpServletRequest));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response XML\n" + xml));
            }
            HttpServletResponse httpServletResponse = webDAVRequest.getHttpServletResponse();
            String lockToken = StringBundler.concat((String[])new String[]{"<", "opaquelocktoken:", lock.getUuid(), ">"});
            httpServletResponse.setContentType("text/xml; charset=UTF-8");
            httpServletResponse.setHeader("Lock-Token", lockToken);
            httpServletResponse.setStatus(status.getCode());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Returning lock token " + lockToken));
            }
            try {
                ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)xml);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block18;
                _log.warn((Throwable)exception);
            }
        }
        return status.getCode();
    }

    protected String getResponseXML(Lock lock, long depth) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element propElement = document.addElement("D:prop", "DAV:");
        Element lockDiscoveryElement = propElement.addElement("D:lockdiscovery");
        Element activeLockElement = lockDiscoveryElement.addElement("D:activelock");
        Element lockTypeElement = activeLockElement.addElement("D:locktype");
        lockTypeElement.addElement("D:write");
        Element lockScopeElement = activeLockElement.addElement("D:lockscope");
        lockScopeElement.addElement("D:exclusive");
        if (depth < 0L) {
            Element depthElement = activeLockElement.addElement("D:depth");
            depthElement.addText("Infinity");
        }
        Element ownerElement = activeLockElement.addElement("D:owner");
        ownerElement.addText(lock.getOwner());
        Element timeoutElement = activeLockElement.addElement("D:timeout");
        long timeoutSecs = lock.getExpirationTime() / 1000L;
        if (timeoutSecs > 0L) {
            timeoutElement.addText("Second-" + timeoutSecs);
        } else {
            timeoutElement.addText("Infinite");
        }
        Element lockTokenElement = activeLockElement.addElement("D:locktoken");
        Element hrefElement = lockTokenElement.addElement("D:href");
        hrefElement.addText("opaquelocktoken:" + lock.getUuid());
        return document.formattedString();
    }
}

