/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.xmlrpc;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.xmlrpc.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class XmlRpcMethodUtil {
    private static final Log _log = LogFactoryUtil.getLog(XmlRpcMethodUtil.class);
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final Map<String, Map<String, Method>> _methodRegistry = new ConcurrentHashMap<String, Map<String, Method>>();
    private static final ServiceTracker<Method, Method> _serviceTracker = new ServiceTracker(_bundleContext, Method.class, (ServiceTrackerCustomizer)new MethodServiceTrackerCustomizer());

    public static Method getMethod(String token, String methodName) {
        Method method = null;
        Map<String, Method> methods = _methodRegistry.get(token);
        if (methods != null) {
            method = methods.get(methodName);
        }
        return method;
    }

    static {
        _serviceTracker.open();
    }

    private static class MethodServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Method, Method> {
        private MethodServiceTrackerCustomizer() {
        }

        public Method addingService(ServiceReference<Method> serviceReference) {
            String methodName;
            Method registeredMethod;
            Method method = (Method)_bundleContext.getService(serviceReference);
            String token = method.getToken();
            Map<String, Method> methods = _methodRegistry.get(token);
            if (methods == null) {
                methods = new HashMap<String, Method>();
                _methodRegistry.put(token, methods);
            }
            if ((registeredMethod = methods.get(methodName = method.getMethodName())) != null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"There is already an XML-RPC method registered ", "with name ", methodName, " at ", token}));
                }
            } else {
                methods.put(methodName, method);
            }
            return method;
        }

        public void modifiedService(ServiceReference<Method> serviceReference, Method method) {
        }

        public void removedService(ServiceReference<Method> serviceReference, Method method) {
            _bundleContext.ungetService(serviceReference);
            String token = method.getToken();
            Map<String, Method> methods = _methodRegistry.get(token);
            if (methods == null) {
                return;
            }
            methods.remove(method.getMethodName());
            if (methods.isEmpty()) {
                _methodRegistry.remove(token);
            }
        }
    }
}

