/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.portlet.Route;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringEncoder;
import com.liferay.portal.kernel.util.StringParser;
import com.liferay.portal.kernel.util.URLStringEncoder;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RouteImpl
implements Route {
    private static final StringEncoder _urlEncoder = new URLStringEncoder();
    private Map<String, StringParser> _generatedParameters;
    private Set<String> _ignoredParameters;
    private Map<String, String> _implicitParameters;
    private Map<String, String> _overriddenParameters;
    private final String _pattern;
    private final StringParser _stringParser;

    public RouteImpl(String pattern) {
        this._pattern = pattern;
        this._stringParser = StringParser.create((String)pattern);
        this._stringParser.setStringEncoder(_urlEncoder);
    }

    public void addGeneratedParameter(String name, String pattern) {
        if (this._generatedParameters == null) {
            this._generatedParameters = new HashMap<String, StringParser>();
        }
        StringParser stringParser = StringParser.create((String)pattern);
        this._generatedParameters.put(name, stringParser);
    }

    public void addIgnoredParameter(String name) {
        if (this._ignoredParameters == null) {
            this._ignoredParameters = new HashSet<String>();
        }
        this._ignoredParameters.add(name);
    }

    public void addImplicitParameter(String name, String value) {
        if (this._implicitParameters == null) {
            this._implicitParameters = new HashMap<String, String>();
        }
        this._implicitParameters.put(name, value);
    }

    public void addOverriddenParameter(String name, String value) {
        if (this._overriddenParameters == null) {
            this._overriddenParameters = new HashMap<String, String>();
        }
        this._overriddenParameters.put(name, value);
    }

    public Map<String, StringParser> getGeneratedParameters() {
        if (this._generatedParameters == null) {
            return Collections.emptyMap();
        }
        return this._generatedParameters;
    }

    public Set<String> getIgnoredParameters() {
        if (this._ignoredParameters == null) {
            return Collections.emptySet();
        }
        return this._ignoredParameters;
    }

    public Map<String, String> getImplicitParameters() {
        if (this._implicitParameters == null) {
            return Collections.emptyMap();
        }
        return this._implicitParameters;
    }

    public Map<String, String> getOverriddenParameters() {
        if (this._overriddenParameters == null) {
            return Collections.emptyMap();
        }
        return this._overriddenParameters;
    }

    public String getPattern() {
        return this._pattern;
    }

    public String parametersToUrl(Map<String, String> parameters) {
        String value;
        HashMap<String, String> allParameters = new HashMap<String, String>(parameters);
        Map<String, StringParser> generatedParameters = this.getGeneratedParameters();
        for (Map.Entry<String, StringParser> entry : generatedParameters.entrySet()) {
            String string = entry.getKey();
            StringParser stringParser = entry.getValue();
            if (stringParser.parse(value = MapUtil.getString(allParameters, (String)string), allParameters)) continue;
            return null;
        }
        Map<String, String> implicitParameters = this.getImplicitParameters();
        for (Map.Entry<String, String> entry : implicitParameters.entrySet()) {
            String name = entry.getKey();
            value = entry.getValue();
            if (value.equals(MapUtil.getString(allParameters, (String)name))) continue;
            return null;
        }
        String string = this._stringParser.build(allParameters);
        if (Validator.isNull((String)string)) {
            return null;
        }
        for (String name : generatedParameters.keySet()) {
            parameters.remove(name);
        }
        for (String name : implicitParameters.keySet()) {
            parameters.remove(name);
        }
        for (String name : this.getIgnoredParameters()) {
            parameters.remove(name);
        }
        return string;
    }

    public boolean urlToParameters(String url, Map<String, String> parameters) {
        if (!this._stringParser.parse(url, parameters)) {
            return false;
        }
        parameters.putAll(this.getImplicitParameters());
        parameters.putAll(this.getOverriddenParameters());
        Map<String, StringParser> generatedParameters = this.getGeneratedParameters();
        for (Map.Entry<String, StringParser> entry : generatedParameters.entrySet()) {
            StringParser stringParser = entry.getValue();
            String value = stringParser.build(parameters);
            if (value == null) continue;
            parameters.put(entry.getKey(), value);
        }
        return true;
    }
}

