/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.admin.util;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.util.PropsValues;

public class OmniadminUtil {
    private static final Log _log = LogFactoryUtil.getLog(OmniadminUtil.class);

    public static boolean isOmniadmin(long userId) {
        if (userId <= 0L) {
            return false;
        }
        try {
            User user = UserLocalServiceUtil.fetchUser((long)userId);
            if (user == null) {
                return false;
            }
            return OmniadminUtil.isOmniadmin(user);
        }
        catch (SystemException systemException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)systemException);
            }
            return false;
        }
    }

    public static boolean isOmniadmin(User user) {
        boolean bl;
        block11: {
            if (PropsValues.OMNIADMIN_USERS.length > 0) {
                for (int i = 0; i < PropsValues.OMNIADMIN_USERS.length; ++i) {
                    if (PropsValues.OMNIADMIN_USERS[i] != user.getUserId()) continue;
                    return user.getCompanyId() == PortalInstancePool.getDefaultCompanyId();
                }
                return false;
            }
            if (user.isGuestUser() || user.getCompanyId() != PortalInstancePool.getDefaultCompanyId()) {
                return false;
            }
            SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)PortalInstancePool.getDefaultCompanyId());
            try {
                bl = RoleLocalServiceUtil.hasUserRole((long)user.getUserId(), (long)user.getCompanyId(), (String)"Administrator", (boolean)true);
                if (safeCloseable == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (safeCloseable != null) {
                        try {
                            safeCloseable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    _log.error((Object)"Unable to check if a user is an omniadmin", (Throwable)exception);
                    return false;
                }
            }
            safeCloseable.close();
        }
        return bl;
    }
}

