/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.model.impl;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.view.count.ViewCountManagerUtil;
import com.liferay.portlet.asset.model.impl.AssetEntryBaseImpl;
import com.liferay.portlet.asset.util.DeletedAssetObjectThreadLocal;
import java.util.List;

public class AssetEntryImpl
extends AssetEntryBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AssetEntryImpl.class);

    public AssetRenderer<?> getAssetRenderer() {
        if (DeletedAssetObjectThreadLocal.isDeletedAssetObject(this.getClassNameId(), this.getClassPK())) {
            return null;
        }
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)this.getClassName());
        try {
            return assetRendererFactory.getAssetRenderer(this.getClassPK());
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to get asset renderer", (Throwable)exception);
            }
            return null;
        }
    }

    public AssetRendererFactory<?> getAssetRendererFactory() {
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)this.getClassName());
    }

    public List<AssetCategory> getCategories() {
        return AssetCategoryLocalServiceUtil.getEntryCategories((long)this.getEntryId());
    }

    public long[] getCategoryIds() {
        return ListUtil.toLongArray(this.getCategories(), (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR);
    }

    public String[] getTagNames() {
        return (String[])ListUtil.toArray(this.getTags(), (Accessor)AssetTag.NAME_ACCESSOR);
    }

    public List<AssetTag> getTags() {
        return AssetTagLocalServiceUtil.getEntryTags((long)this.getEntryId());
    }

    public long getViewCount() {
        return ViewCountManagerUtil.getViewCount((long)this.getCompanyId(), (long)ClassNameLocalServiceUtil.getClassNameId(AssetEntry.class), (long)this.getPrimaryKey());
    }
}

