/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.AssetTagDisplay;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Autocomplete;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.service.base.AssetTagServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetTagsPermission;
import com.liferay.portlet.asset.util.comparator.AssetTagNameComparator;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.List;

public class AssetTagServiceImpl
extends AssetTagServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AssetTagServiceImpl.class);

    public AssetTag addTag(String externalReferenceCode, long groupId, String name, ServiceContext serviceContext) throws PortalException {
        AssetTagsPermission.check(this.getPermissionChecker(), groupId, "MANAGE_TAG");
        return this.assetTagLocalService.addTag(externalReferenceCode, this.getUserId(), groupId, name, serviceContext);
    }

    public void deleteTag(long tagId) throws PortalException {
        this.deleteTags(new long[]{tagId});
    }

    public void deleteTags(long[] tagIds) throws PortalException {
        for (long tagId : tagIds) {
            AssetTag tag = this.assetTagLocalService.getTag(tagId);
            AssetTagsPermission.check(this.getPermissionChecker(), tag.getGroupId(), "MANAGE_TAG");
            this.assetTagLocalService.deleteTag(tagId);
        }
    }

    public AssetTag fetchAssetTagByExternalReferenceCode(String externalReferenceCode, long groupId) {
        return this.sanitize(this.assetTagLocalService.fetchAssetTagByExternalReferenceCode(externalReferenceCode, groupId));
    }

    public AssetTag getAssetTagByExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        return this.sanitize(this.assetTagLocalService.getAssetTagByExternalReferenceCode(externalReferenceCode, groupId));
    }

    public List<AssetTag> getGroupsTags(long[] groupIds) {
        return this.sanitize(this.assetTagPersistence.findByGroupId(groupIds, -1, -1, (OrderByComparator)new AssetTagNameComparator()));
    }

    public List<AssetTag> getGroupTags(long groupId) {
        return this.sanitize(this.assetTagPersistence.findByGroupId(groupId));
    }

    public List<AssetTag> getGroupTags(long groupId, int start, int end, OrderByComparator<AssetTag> orderByComparator) {
        return this.sanitize(this.assetTagPersistence.findByGroupId(groupId, start, end, orderByComparator));
    }

    public int getGroupTagsCount(long groupId) {
        return this.assetTagPersistence.countByGroupId(groupId);
    }

    public AssetTagDisplay getGroupTagsDisplay(long groupId, String name, int start, int end) {
        List<AssetTag> tags = null;
        int total = 0;
        if (Validator.isNotNull((String)name)) {
            name = CustomSQLUtil.keywords((String)name)[0];
            tags = this.getTags(groupId, name, start, end);
            total = this.getTagsCount(groupId, name);
        } else {
            tags = this.getGroupTags(groupId, start, end, null);
            total = this.getGroupTagsCount(groupId);
        }
        return new AssetTagDisplay(tags, total, start, end);
    }

    public AssetTag getTag(long tagId) throws PortalException {
        return this.sanitize(this.assetTagLocalService.getTag(tagId));
    }

    public List<AssetTag> getTags(long groupId, long classNameId, String name) {
        return this.sanitize(this.assetTagFinder.findByG_C_N(groupId, classNameId, name, -1, -1, null));
    }

    public List<AssetTag> getTags(long groupId, long classNameId, String name, int start, int end, OrderByComparator<AssetTag> orderByComparator) {
        return this.sanitize(this.assetTagFinder.findByG_C_N(groupId, classNameId, name, start, end, orderByComparator));
    }

    public List<AssetTag> getTags(long groupId, String name, int start, int end) {
        return this.getTags(new long[]{groupId}, name, start, end);
    }

    public List<AssetTag> getTags(long groupId, String name, int start, int end, OrderByComparator<AssetTag> orderByComparator) {
        return this.getTags(new long[]{groupId}, name, start, end, orderByComparator);
    }

    public List<AssetTag> getTags(long[] groupIds, String name, int start, int end) {
        return this.getTags(groupIds, name, start, end, (OrderByComparator<AssetTag>)new AssetTagNameComparator());
    }

    public List<AssetTag> getTags(long[] groupIds, String name, int start, int end, OrderByComparator<AssetTag> orderByComparator) {
        if (Validator.isNull((String)name)) {
            return this.sanitize(this.assetTagPersistence.findByGroupId(groupIds, start, end, orderByComparator));
        }
        return this.sanitize(this.assetTagPersistence.findByG_LikeN(groupIds, StringUtil.quote((String)name, (String)"%"), start, end, orderByComparator));
    }

    public List<AssetTag> getTags(String className, long classPK) {
        return this.sanitize(this.assetTagLocalService.getTags(className, classPK));
    }

    public int getTagsCount(long groupId, String name) {
        if (Validator.isNull((String)name)) {
            return this.assetTagPersistence.countByGroupId(groupId);
        }
        return this.assetTagPersistence.countByG_LikeN(groupId, StringUtil.quote((String)name, (String)"%"));
    }

    public int getTagsCount(long[] groupIds, String name) {
        if (Validator.isNull((String)name)) {
            return this.assetTagPersistence.countByGroupId(groupIds);
        }
        return this.assetTagPersistence.countByG_LikeN(groupIds, StringUtil.quote((String)name, (String)"%"));
    }

    public int getVisibleAssetsTagsCount(long groupId, long classNameId, String name) {
        return this.assetTagFinder.countByG_C_N(groupId, classNameId, name);
    }

    public void mergeTags(long fromTagId, long toTagId) throws PortalException {
        AssetTag tag = this.assetTagLocalService.getTag(fromTagId);
        AssetTagsPermission.check(this.getPermissionChecker(), tag.getGroupId(), "MANAGE_TAG");
        this.assetTagLocalService.mergeTags(fromTagId, toTagId);
    }

    public void mergeTags(long[] fromTagIds, long toTagId) throws PortalException {
        for (long fromTagId : fromTagIds) {
            this.mergeTags(fromTagId, toTagId);
        }
    }

    public JSONArray search(long groupId, String name, int start, int end) {
        return this.search(new long[]{groupId}, name, start, end);
    }

    @AccessControlled(guestAccessEnabled=true)
    public JSONArray search(long[] groupIds, String name, int start, int end) {
        return Autocomplete.arrayToJSONArray(this.getTags(groupIds, name, start, end), (String)"name", (String)"name");
    }

    public void subscribeTag(long userId, long groupId, long tagId) throws PortalException {
        AssetTagsPermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        this.assetTagLocalService.subscribeTag(userId, groupId, tagId);
    }

    public void unsubscribeTag(long userId, long tagId) throws PortalException {
        AssetTag tag = this.assetTagLocalService.getTag(tagId);
        AssetTagsPermission.check(this.getPermissionChecker(), tag.getGroupId(), "SUBSCRIBE");
        this.assetTagLocalService.unsubscribeTag(userId, tagId);
    }

    public AssetTag updateTag(String externalReferenceCode, long tagId, String name, ServiceContext serviceContext) throws PortalException {
        AssetTag tag = this.assetTagLocalService.getTag(tagId);
        AssetTagsPermission.check(this.getPermissionChecker(), tag.getGroupId(), "MANAGE_TAG");
        return this.assetTagLocalService.updateTag(externalReferenceCode, this.getUserId(), tagId, name, serviceContext);
    }

    protected AssetTag sanitize(AssetTag tag) {
        if (tag == null) {
            return null;
        }
        try {
            PermissionChecker permissionChecker = this.getPermissionChecker();
            if (permissionChecker.isCompanyAdmin(tag.getCompanyId()) || tag.getUserId() == permissionChecker.getUserId()) {
                return tag;
            }
        }
        catch (PrincipalException principalException) {
            _log.error((Throwable)principalException);
        }
        tag.setUserId(0L);
        tag.setUserName("");
        tag.setUserUuid("");
        return tag;
    }

    protected List<AssetTag> sanitize(List<AssetTag> tags) {
        for (AssetTag tag : tags) {
            this.sanitize(tag);
        }
        return tags;
    }
}

