/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util.comparator;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.portal.kernel.util.CollatorUtil;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

public class AssetCategoryAssetVocabularyLocalizedTitleComparator
implements Comparator<AssetCategory> {
    private final boolean _ascending;
    private final Locale _locale;
    private final long _vocabularyId;

    public AssetCategoryAssetVocabularyLocalizedTitleComparator(long vocabularyId, Locale locale, boolean ascending) {
        this._vocabularyId = vocabularyId;
        this._locale = locale;
        this._ascending = ascending;
    }

    @Override
    public int compare(AssetCategory assetCategory1, AssetCategory assetCategory2) {
        int value = 0;
        if (assetCategory1.getVocabularyId() == this._vocabularyId && assetCategory2.getVocabularyId() != this._vocabularyId) {
            value = -1;
        } else if (assetCategory1.getVocabularyId() != this._vocabularyId && assetCategory2.getVocabularyId() == this._vocabularyId) {
            value = 1;
        } else if (this._vocabularyId == 0L || assetCategory1.getVocabularyId() != assetCategory2.getVocabularyId()) {
            value = Long.compare(assetCategory1.getVocabularyId(), assetCategory2.getVocabularyId());
        }
        if (value == 0) {
            Collator collator = CollatorUtil.getInstance((Locale)this._locale);
            String assetCategoryTitle1 = assetCategory1.getTitle(this._locale);
            String assetCategoryTitle2 = assetCategory2.getTitle(this._locale);
            value = collator.compare(assetCategoryTitle1, assetCategoryTitle2);
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }
}

