/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileEntryTypeTable;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionRegistryUtil;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryTypeServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.DLPortletResourcePermissionUtil;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DLFileEntryTypeServiceImpl
extends DLFileEntryTypeServiceBaseImpl {
    public DLFileEntryType addFileEntryType(String externalReferenceCode, long groupId, long dataDefinitionId, String fileEntryTypeKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        PortletResourcePermission portletResourcePermission = DLPortletResourcePermissionUtil.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_DOCUMENT_TYPE");
        return this.dlFileEntryTypeLocalService.addFileEntryType(externalReferenceCode, this.getUserId(), groupId, dataDefinitionId, fileEntryTypeKey, nameMap, descriptionMap, serviceContext);
    }

    public void deleteFileEntryType(long fileEntryTypeId) throws PortalException {
        ModelResourcePermission dlFileEntryTypeModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)DLFileEntryType.class.getName());
        dlFileEntryTypeModelResourcePermission.check(this.getPermissionChecker(), fileEntryTypeId, "DELETE");
        this.dlFileEntryTypeLocalService.deleteFileEntryType(fileEntryTypeId);
    }

    public void deleteFileEntryTypeByExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        ModelResourcePermission dlFileEntryTypeModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)DLFileEntryType.class.getName());
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.findByERC_G(externalReferenceCode, groupId);
        dlFileEntryTypeModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)dlFileEntryType, "DELETE");
        this.dlFileEntryTypeLocalService.deleteFileEntryType(dlFileEntryType);
    }

    public DLFileEntryType fetchFileEntryTypeByExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.fetchByERC_G(externalReferenceCode, groupId);
        if (dlFileEntryType == null) {
            return null;
        }
        if (dlFileEntryType.getFileEntryTypeId() == 0L) {
            return dlFileEntryType;
        }
        ModelResourcePermission dlFileEntryTypeModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)DLFileEntryType.class.getName());
        dlFileEntryTypeModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)dlFileEntryType, "VIEW");
        return dlFileEntryType;
    }

    public DLFileEntryType getFileEntryType(long fileEntryTypeId) throws PortalException {
        if (fileEntryTypeId != 0L) {
            ModelResourcePermission dlFileEntryTypeModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)DLFileEntryType.class.getName());
            dlFileEntryTypeModelResourcePermission.check(this.getPermissionChecker(), fileEntryTypeId, "VIEW");
        }
        return this.dlFileEntryTypeLocalService.getFileEntryType(fileEntryTypeId);
    }

    public DLFileEntryType getFileEntryTypeByExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.findByERC_G(externalReferenceCode, groupId);
        if (dlFileEntryType.getFileEntryTypeId() == 0L) {
            return dlFileEntryType;
        }
        ModelResourcePermission dlFileEntryTypeModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)DLFileEntryType.class.getName());
        dlFileEntryTypeModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)dlFileEntryType, "VIEW");
        return dlFileEntryType;
    }

    public List<DLFileEntryType> getFileEntryTypes(long[] groupIds) {
        ArrayList<DLFileEntryType> dlFileEntryTypes = new ArrayList<DLFileEntryType>(this.dlFileEntryTypePersistence.filterFindByGroupId(groupIds));
        DLFileEntryType basicDocumentDLFileEntryType = this.dlFileEntryTypeLocalService.fetchDLFileEntryType(0L);
        if (basicDocumentDLFileEntryType != null) {
            dlFileEntryTypes.add(0, basicDocumentDLFileEntryType);
        }
        return dlFileEntryTypes;
    }

    public List<DLFileEntryType> getFileEntryTypes(long[] groupIds, int start, int end) {
        return this.dlFileEntryTypePersistence.filterFindByGroupId(groupIds, start, end);
    }

    public int getFileEntryTypesCount(long[] groupIds) {
        return this.dlFileEntryTypePersistence.filterCountByGroupId(groupIds);
    }

    public List<DLFileEntryType> getFolderFileEntryTypes(long[] groupIds, long folderId, boolean inherited) throws PortalException {
        return this.filterFileEntryTypes(this.dlFileEntryTypeLocalService.getFolderFileEntryTypes(groupIds, folderId, inherited));
    }

    public List<DLFileEntryType> search(long companyId, long folderId, long[] groupIds, String keywords, boolean includeBasicFileEntryType, boolean inherited, int start, int end) throws PortalException {
        return this.dlFileEntryTypeFinder.filterFindByKeywords(companyId, folderId, groupIds, keywords, includeBasicFileEntryType, inherited, start, end);
    }

    public List<DLFileEntryType> search(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType, int scope, int start, int end, OrderByComparator<DLFileEntryType> orderByComparator) {
        return (List)this.dlFileEntryTypePersistence.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)DLFileEntryTypeTable.INSTANCE), companyId, groupIds, keywords, includeBasicFileEntryType, scope).orderBy((Table)DLFileEntryTypeTable.INSTANCE, orderByComparator).limit(start, end));
    }

    public List<DLFileEntryType> search(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType, int start, int end, OrderByComparator<DLFileEntryType> orderByComparator) {
        return this.dlFileEntryTypeFinder.filterFindByKeywords(companyId, groupIds, keywords, includeBasicFileEntryType, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long folderId, long[] groupIds, String keywords, boolean includeBasicFileEntryType, boolean inherited) {
        return this.dlFileEntryTypeFinder.filterCountByKeywords(companyId, folderId, groupIds, keywords, includeBasicFileEntryType, inherited);
    }

    public int searchCount(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType) {
        return this.dlFileEntryTypeFinder.filterCountByKeywords(companyId, groupIds, keywords, includeBasicFileEntryType);
    }

    public int searchCount(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType, int scope) {
        return this.dlFileEntryTypePersistence.dslQueryCount((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)DLFileEntryTypeTable.INSTANCE.fileEntryTypeId), companyId, groupIds, keywords, includeBasicFileEntryType, scope));
    }

    public DLFileEntryType updateFileEntryType(long fileEntryTypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap) throws PortalException {
        ModelResourcePermission dlFileEntryTypeModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)DLFileEntryType.class.getName());
        dlFileEntryTypeModelResourcePermission.check(this.getPermissionChecker(), fileEntryTypeId, "UPDATE");
        return this.dlFileEntryTypeLocalService.updateFileEntryType(fileEntryTypeId, nameMap, descriptionMap);
    }

    protected List<DLFileEntryType> filterFileEntryTypes(List<DLFileEntryType> fileEntryTypes) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        fileEntryTypes = ListUtil.copy(fileEntryTypes);
        Iterator iterator = fileEntryTypes.iterator();
        while (iterator.hasNext()) {
            ModelResourcePermission dlFileEntryTypeModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)DLFileEntryType.class.getName());
            DLFileEntryType fileEntryType = (DLFileEntryType)iterator.next();
            if (fileEntryType.getFileEntryTypeId() <= 0L || dlFileEntryTypeModelResourcePermission.contains(permissionChecker, (ClassedModel)fileEntryType, "VIEW")) continue;
            iterator.remove();
        }
        return fileEntryTypes;
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType, int scope) {
        return fromStep.from((Table)DLFileEntryTypeTable.INSTANCE).where(() -> {
            Predicate predicate = DLFileEntryTypeTable.INSTANCE.companyId.eq((Object)companyId);
            Predicate groupIdsPredicate = null;
            for (long groupId : groupIds) {
                Predicate groupIdPredicate = DLFileEntryTypeTable.INSTANCE.groupId.eq((Object)groupId);
                groupIdsPredicate = groupIdsPredicate == null ? groupIdPredicate : groupIdsPredicate.or((Expression)groupIdPredicate);
            }
            if (groupIdsPredicate != null) {
                predicate = predicate.and((Expression)groupIdsPredicate.withParentheses());
            }
            if (includeBasicFileEntryType) {
                predicate = predicate.withParentheses().or((Expression)DLFileEntryTypeTable.INSTANCE.groupId.eq((Object)0L));
            }
            predicate = predicate.withParentheses().and((Expression)DLFileEntryTypeTable.INSTANCE.scope.eq((Object)scope));
            Predicate keywordsPredicate = null;
            for (String keyword : CustomSQLUtil.keywords((String)keywords, (boolean)true)) {
                if (keyword == null) continue;
                Predicate keywordPredicate = DSLFunctionFactoryUtil.lower((Expression)DLFileEntryTypeTable.INSTANCE.name).like(keyword).or((Expression)DSLFunctionFactoryUtil.lower((Expression)DLFileEntryTypeTable.INSTANCE.description).like(keyword));
                keywordsPredicate = keywordsPredicate == null ? keywordPredicate : keywordsPredicate.or((Expression)keywordPredicate);
            }
            if (keywordsPredicate != null) {
                predicate = predicate.and((Expression)keywordsPredicate.withParentheses());
            }
            return predicate;
        });
    }
}

