/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.exception.InvalidFolderException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFolderLocalServiceUtil;
import com.liferay.document.library.kernel.util.DL;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelCreateDateComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelModifiedDateComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelReadCountComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelSizeComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelTitleComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.portlet.PortletLayoutFinder;
import com.liferay.portal.kernel.portlet.PortletLayoutFinderRegistryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalServiceUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.helper.TrashHelper;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class DLImpl
implements DL {
    private static final String _DEFAULT_FILE_ICON = "page";
    private static final String _DEFAULT_GENERIC_NAME = "default";
    private static final long _DIVISOR = 256L;
    private static final String[] _MICROSOFT_OFFICE_EXTENSIONS;
    private static final String _STRUCTURE_KEY_PREFIX = "AUTO_";
    private static final Log _log;
    private static final Set<String> _allMediaGalleryMimeTypes;
    private static final Set<String> _fileIcons;
    private static final Map<String, String> _genericNames;
    private static final Snapshot<TrashHelper> _trashHelperSnapshot;

    public int compareVersions(String version1, String version2) {
        int[] splitVersion1 = StringUtil.split((String)version1, (String)".", (int)0);
        int[] splitVersion2 = StringUtil.split((String)version2, (String)".", (int)0);
        if (splitVersion1.length != 2 && splitVersion2.length != 2) {
            return 0;
        }
        if (splitVersion1.length != 2) {
            return -1;
        }
        if (splitVersion2.length != 2) {
            return 1;
        }
        if (splitVersion1[0] > splitVersion2[0]) {
            return 1;
        }
        if (splitVersion1[0] < splitVersion2[0]) {
            return -1;
        }
        if (splitVersion1[1] > splitVersion2[1]) {
            return 1;
        }
        if (splitVersion1[1] < splitVersion2[1]) {
            return -1;
        }
        return 0;
    }

    public void destroy() {
    }

    public String getAbsolutePath(PortletRequest portletRequest, long rootFolderId, long folderId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (folderId == 0L || rootFolderId == folderId) {
            return themeDisplay.translate("home");
        }
        Folder folder = DLAppLocalServiceUtil.getFolder((long)folderId);
        List folders = folder.getAncestors();
        if (rootFolderId != 0L) {
            Folder rootFolder = DLAppLocalServiceUtil.getFolder((long)rootFolderId);
            if (!folders.contains(rootFolder)) {
                throw new InvalidFolderException(5, rootFolderId);
            }
            folders = ListUtil.subList((List)folders, (int)0, (int)folders.indexOf(rootFolder));
        }
        Collections.reverse(folders);
        StringBundler sb = new StringBundler(folders.size() * 4 + 5);
        sb.append(themeDisplay.translate("home"));
        for (Folder curFolder : folders) {
            sb.append(" ");
            sb.append("\u00bb");
            sb.append(" ");
            sb.append(curFolder.getName());
        }
        sb.append(" ");
        sb.append("\u00bb");
        sb.append(" ");
        sb.append(folder.getName());
        return sb.toString();
    }

    public Set<String> getAllMediaGalleryMimeTypes() {
        return _allMediaGalleryMimeTypes;
    }

    public String getDDMStructureKey(DLFileEntryType dlFileEntryType) {
        return this.getDDMStructureKey(dlFileEntryType.getUuid());
    }

    public String getDDMStructureKey(String fileEntryTypeUuid) {
        return _STRUCTURE_KEY_PREFIX + StringUtil.toUpperCase((String)fileEntryTypeUuid);
    }

    public String getDeprecatedDDMStructureKey(DLFileEntryType dlFileEntryType) {
        return this.getDeprecatedDDMStructureKey(dlFileEntryType.getFileEntryTypeId());
    }

    public String getDeprecatedDDMStructureKey(long fileEntryTypeId) {
        return _STRUCTURE_KEY_PREFIX + fileEntryTypeId;
    }

    public String getDividedPath(long id) {
        StringBundler sb = new StringBundler(16);
        long dividend = id;
        while (dividend / 256L != 0L) {
            sb.append("/");
            sb.append(dividend % 256L);
            dividend /= 256L;
        }
        sb.append("/");
        sb.append(id);
        return sb.toString();
    }

    public Map<String, String> getEmailDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return LinkedHashMapBuilder.put((Object)"[$COMPANY_ID$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-document")).put((Object)"[$COMPANY_MX$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-document")).put((Object)"[$COMPANY_NAME$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-document")).put((Object)"[$DOCUMENT_STATUS_BY_USER_NAME$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-updated-the-document")).put((Object)"[$DOCUMENT_TITLE$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-document-title")).put((Object)"[$DOCUMENT_TYPE$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-document-type")).put((Object)"[$DOCUMENT_URL$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-document-url")).put((Object)"[$DOCUMENT_USER_ADDRESS$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-user-who-added-the-document")).put((Object)"[$DOCUMENT_USER_NAME$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-document")).put((Object)"[$FOLDER_NAME$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-folder-in-which-the-document-has-been-added")).put((Object)"[$FROM_ADDRESS$]", (Object)HtmlUtil.escape((String)emailFromAddress)).put((Object)"[$FROM_NAME$]", (Object)HtmlUtil.escape((String)emailFromName)).put((Object)"[$PORTAL_URL$]", () -> {
            Company company = themeDisplay.getCompany();
            return company.getVirtualHostname();
        }).put((Object)"[$PORTLET_NAME$]", () -> {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            return HtmlUtil.escape((String)portletDisplay.getTitle());
        }).put((Object)"[$SITE_NAME$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-document")).put((Object)"[$TO_ADDRESS$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-address-of-the-email-recipient")).put((Object)"[$TO_NAME$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-email-recipient")).build();
    }

    public Map<String, String> getEmailFromDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return LinkedHashMapBuilder.put((Object)"[$COMPANY_ID$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-document")).put((Object)"[$COMPANY_MX$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-document")).put((Object)"[$COMPANY_NAME$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-document")).put((Object)"[$DOCUMENT_STATUS_BY_USER_NAME$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-updated-the-document")).put((Object)"[$DOCUMENT_USER_ADDRESS$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-user-who-added-the-document")).put((Object)"[$DOCUMENT_USER_NAME$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-document")).put((Object)"[$PORTLET_NAME$]", () -> {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            return HtmlUtil.escape((String)portletDisplay.getTitle());
        }).put((Object)"[$SITE_NAME$]", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-document")).build();
    }

    public List<FileEntry> getFileEntries(Hits hits) {
        ArrayList<FileEntry> entries = new ArrayList<FileEntry>();
        for (Document document : hits.getDocs()) {
            long fileEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            try {
                entries.add(DLAppLocalServiceUtil.getFileEntry((long)fileEntryId));
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Documents and Media search index is stale and contains file entry " + fileEntryId), (Throwable)exception);
            }
        }
        return entries;
    }

    public String getFileEntryImage(FileEntry fileEntry, ThemeDisplay themeDisplay) {
        return StringBundler.concat((String[])new String[]{"<img src=\"", themeDisplay.getPathThemeImages(), "/file_system/small/", fileEntry.getIcon(), ".png\" style=\"border-width: 0; text-align: left;\">"});
    }

    public String getFileIcon(String extension) {
        if (!_fileIcons.contains(extension)) {
            extension = _DEFAULT_FILE_ICON;
        }
        return extension;
    }

    public String getFileIconCssClass(String extension) {
        return "documents-and-media";
    }

    public String getGenericName(String extension) {
        String genericName = _genericNames.get(extension);
        if (genericName == null) {
            genericName = _DEFAULT_GENERIC_NAME;
        }
        return genericName;
    }

    @Deprecated
    public String getPreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString) {
        return this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, true, true);
    }

    @Deprecated
    public String getPreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendVersion, boolean absoluteURL) {
        StringBundler sb = new StringBundler(15);
        if (themeDisplay != null && absoluteURL) {
            sb.append(themeDisplay.getPortalURL());
        }
        sb.append(PortalUtil.getPathContext());
        sb.append("/documents/");
        sb.append(fileEntry.getRepositoryId());
        sb.append("/");
        sb.append(fileEntry.getFolderId());
        sb.append("/");
        String fileName = fileEntry.getFileName();
        if (fileEntry.isInTrash()) {
            TrashHelper trashHelper = (TrashHelper)_trashHelperSnapshot.get();
            fileName = trashHelper.getOriginalTitle(fileEntry.getFileName());
        }
        sb.append(URLCodec.encodeURL((String)HtmlUtil.unescape((String)fileName)));
        sb.append("/");
        sb.append(URLCodec.encodeURL((String)fileEntry.getUuid()));
        if (appendVersion) {
            sb.append("?version=");
            sb.append(fileVersion.getVersion());
            sb.append("&t=");
        } else {
            sb.append("?t=");
        }
        Date modifiedDate = fileVersion.getModifiedDate();
        sb.append(modifiedDate.getTime());
        sb.append(queryString);
        String previewURL = sb.toString();
        if (themeDisplay != null) {
            if (Validator.isNotNull((String)themeDisplay.getDoAsUserId())) {
                previewURL = PortalUtil.addPreservedParameters((ThemeDisplay)themeDisplay, (String)previewURL, (boolean)false, (boolean)true);
            }
            if (themeDisplay.isAddSessionIdToURL()) {
                previewURL = PortalUtil.getURLWithSessionId((String)previewURL, (String)themeDisplay.getSessionId());
            }
        }
        return previewURL;
    }

    public <T> OrderByComparator<T> getRepositoryModelOrderByComparator(String orderByCol, String orderByType) {
        return this.getRepositoryModelOrderByComparator(orderByCol, orderByType, false);
    }

    public <T> OrderByComparator<T> getRepositoryModelOrderByComparator(String orderByCol, String orderByType, boolean orderByModel) {
        boolean orderByAsc = true;
        if (orderByType.equals("desc")) {
            orderByAsc = false;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("creationDate") ? new RepositoryModelCreateDateComparator(orderByAsc, orderByModel) : (orderByCol.equals("downloads") ? new RepositoryModelReadCountComparator(orderByAsc, orderByModel) : (orderByCol.equals("modifiedDate") ? new RepositoryModelModifiedDateComparator(orderByAsc, orderByModel) : (orderByCol.equals("size") ? new RepositoryModelSizeComparator(orderByAsc, orderByModel) : (orderByCol.equals("title") ? new RepositoryModelTitleComparator(orderByAsc, orderByModel) : new RepositoryModelModifiedDateComparator(orderByAsc, orderByModel)))));
        return orderByComparator;
    }

    public String getSanitizedFileName(String title, String extension) {
        Object fileName = StringUtil.replace((String)title, (char)'/', (char)'_');
        if (Validator.isNotNull((String)extension) && !StringUtil.endsWith((String)fileName, (String)("." + extension))) {
            fileName = (String)fileName + "." + extension;
        }
        if (((String)fileName).length() > 255) {
            int x = ((String)fileName).length() - 1;
            if (Validator.isNotNull((String)extension)) {
                x = ((String)fileName).lastIndexOf(".");
            }
            int y = x - (((String)fileName).length() - 255);
            fileName = ((String)fileName).substring(0, y) + ((String)fileName).substring(x);
        }
        return fileName;
    }

    public String getTempFileId(long id, String version) {
        return this.getTempFileId(id, version, null);
    }

    public String getTempFileId(long id, String version, String languageId) {
        if (Validator.isNull((String)languageId)) {
            return StringBundler.concat((Object[])new Object[]{id, ".", version});
        }
        return StringBundler.concat((Object[])new Object[]{id, ".", version, ".", languageId});
    }

    public String getThumbnailStyle() {
        return this.getThumbnailStyle(true, 0);
    }

    public String getThumbnailStyle(boolean max, int margin) {
        return this.getThumbnailStyle(max, margin, PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.height"), PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.width"));
    }

    public String getThumbnailStyle(boolean max, int margin, int height, int width) {
        StringBundler sb = new StringBundler(5);
        if (max) {
            sb.append("max-height: ");
        } else {
            sb.append("height: ");
        }
        sb.append(height += 2 * margin);
        if (max) {
            sb.append("px; max-width: ");
        } else {
            sb.append("px; width: ");
        }
        sb.append(width += 2 * margin);
        sb.append("px;");
        return sb.toString();
    }

    public String getTitleWithExtension(FileEntry fileEntry) {
        return this.getTitleWithExtension(fileEntry.getTitle(), fileEntry.getExtension());
    }

    public String getTitleWithExtension(String title, String extension) {
        String periodAndExtension;
        if (Validator.isNotNull((String)extension) && !((String)title).endsWith(periodAndExtension = ".".concat(extension))) {
            title = (String)title + periodAndExtension;
        }
        return title;
    }

    public String getUniqueFileName(long groupId, long folderId, String fileName, boolean ignoreDuplicateTitle) {
        String uniqueFileTitle = FileUtil.stripExtension((String)fileName);
        String extension = FileUtil.getExtension((String)fileName);
        int i = 1;
        while (!ignoreDuplicateTitle && this._existsFileEntryByTitle(groupId, folderId, uniqueFileTitle) || this._existsFileEntryByFileName(groupId, extension, folderId, uniqueFileTitle)) {
            uniqueFileTitle = FileUtil.appendParentheticalSuffix((String)FileUtil.stripExtension((String)fileName), (String)String.valueOf(i));
            ++i;
        }
        return this.getTitleWithExtension(uniqueFileTitle, extension);
    }

    public String getUniqueTitle(long groupId, long folderId, String title) {
        String uniqueFileTitle = title;
        int i = 1;
        while (this._existsFileEntryByTitle(groupId, folderId, uniqueFileTitle)) {
            uniqueFileTitle = FileUtil.appendParentheticalSuffix((String)title, (String)String.valueOf(i));
            ++i;
        }
        return uniqueFileTitle;
    }

    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, long folderId, long fileEntryTypeId) {
        while (folderId != 0L) {
            DLFolder dlFolder = DLFolderLocalServiceUtil.fetchDLFolder((long)folderId);
            if (dlFolder == null) {
                return false;
            }
            if (dlFolder.getRestrictionType() != 0) break;
            folderId = dlFolder.getParentFolderId();
        }
        return WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink((long)companyId, (long)groupId, (String)DLFolderConstants.getClassName(), (long)folderId, (long)fileEntryTypeId) || WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink((long)companyId, (long)groupId, (String)DLFolderConstants.getClassName(), (long)folderId, (long)-1L);
    }

    public boolean isAutoGeneratedDLFileEntryTypeDDMStructureKey(String ddmStructureKey) {
        return ddmStructureKey.startsWith(_STRUCTURE_KEY_PREFIX);
    }

    public boolean isOfficeExtension(String extension) {
        return ArrayUtil.contains((Object[])_MICROSOFT_OFFICE_EXTENSIONS, (Object)extension);
    }

    public boolean isValidVersion(String version) {
        if ((version = this._stripVersionSuffix(version)).equals("PWC")) {
            return true;
        }
        String[] versionParts = StringUtil.split((String)version, (String)".");
        if (versionParts.length != 2) {
            return false;
        }
        return Validator.isNumber((String)versionParts[0]) && Validator.isNumber((String)versionParts[1]);
    }

    public void startWorkflowInstance(long userId, DLFileVersion dlFileVersion, String syncEventType, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = HashMapBuilder.put((Object)"url", (Object)this.getEntryURL(dlFileVersion, serviceContext)).put((Object)"event", (Object)syncEventType).build();
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)dlFileVersion.getCompanyId(), (long)dlFileVersion.getGroupId(), (long)userId, (String)DLFileEntryConstants.getClassName(), (long)dlFileVersion.getFileVersionId(), (Object)dlFileVersion, (ServiceContext)serviceContext, (Map)workflowContext);
    }

    protected String getEntryURL(DLFileVersion dlFileVersion, ServiceContext serviceContext) throws PortalException {
        if (Objects.equals(serviceContext.getCommand(), "add_webdav") || Objects.equals(serviceContext.getCommand(), "update_webdav")) {
            return serviceContext.getPortalURL() + serviceContext.getCurrentURL();
        }
        String entryURL = GetterUtil.getString((Object)serviceContext.getAttribute("entryURL"));
        if (Validator.isNotNull((String)entryURL)) {
            return entryURL;
        }
        boolean hasAssetDisplayPage = GetterUtil.getBoolean((Object)serviceContext.getAttribute("hasAssetDisplayPage"));
        if (hasAssetDisplayPage) {
            return "";
        }
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        if (httpServletRequest == null || themeDisplay == null) {
            return "";
        }
        Object portletURL = null;
        long plid = serviceContext.getPlid();
        long controlPanelPlid = PortalUtil.getControlPanelPlid((long)serviceContext.getCompanyId());
        String portletId = PortletProviderUtil.getPortletId((String)FileEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        DLFileEntry fileEntry = dlFileVersion.getFileEntry();
        PortletLayoutFinder portletLayoutFinder = PortletLayoutFinderRegistryUtil.getPortletLayoutFinder((String)DLFileEntryConstants.getClassName());
        PortletLayoutFinder.Result result = portletLayoutFinder.find(themeDisplay, fileEntry.getGroupId());
        if (result != null) {
            portletId = result.getPortletId();
            plid = result.getPlid();
        }
        portletURL = plid == controlPanelPlid || plid == 0L ? PortalUtil.getControlPanelPortletURL((HttpServletRequest)httpServletRequest, (String)portletId, (String)"RENDER_PHASE") : PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)portletId, (long)plid, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(dlFileVersion.getFileEntryId()));
        return portletURL.toString();
    }

    protected String getImageSrc(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString) {
        return this.getImageSrc(fileEntry, fileVersion, themeDisplay, queryString, true, true);
    }

    protected String getImageSrc(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendVersion, boolean absoluteURL) {
        String thumbnailSrc = "";
        if (Validator.isNotNull((String)queryString)) {
            thumbnailSrc = this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, appendVersion, absoluteURL);
        }
        return thumbnailSrc;
    }

    private static void _populateGenericNamesMap(String genericName) {
        String[] extensions;
        for (String extension : extensions = PropsUtil.getArray((String)"dl.file.generic.extensions", (Filter)new Filter(genericName))) {
            _genericNames.put(extension, genericName);
        }
    }

    private boolean _existsFileEntryByFileName(long groupId, String extension, long folderId, String title) {
        try {
            DLAppLocalServiceUtil.getFileEntryByFileName((long)groupId, (long)folderId, (String)this.getTitleWithExtension(title, extension));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return false;
        }
        return true;
    }

    private boolean _existsFileEntryByTitle(long groupId, long folderId, String uniqueFileTitle) {
        try {
            DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)uniqueFileTitle);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return false;
        }
        return true;
    }

    private String _stripVersionSuffix(String version) {
        int index = version.indexOf(126);
        if (index != -1) {
            return version.substring(0, index);
        }
        if (version.endsWith(".index")) {
            return StringUtil.removeLast((String)version, (String)".index");
        }
        return version;
    }

    static {
        String[] genericNames;
        _MICROSOFT_OFFICE_EXTENSIONS = new String[]{"accda", "accdb", "accdc", "accde", "accdp", "accdr", "accdt", "accdu", "acl", "ade", "adp", "asd", "cnv", "crtx", "doc", "docm", "docx", "dot", "dotm", "dotx", "grv", "iaf", "laccdb", "maf", "mam", "maq", "mar", "mat", "mda", "mdb", "mde", "mdt", "mdw", "mpd", "mpp", "mpt", "oab", "obi", "oft", "olm", "one", "onepkg", "ops", "ost", "pa", "pip", "pot", "potm", "potx", "ppa", "ppam", "pps", "ppsm", "ppsx", "ppt", "pptm", "pptx", "prf", "pst", "pub", "puz", "rpmsg", "sldm", "sldx", "slk", "snp", "svd", "thmx", "vdx", "vrge08message", "vsd", "vss", "vst", "vsx", "vtx", "wbk", "wll", "xar", "xl", "xla", "xlam", "xlb", "xlc", "xll", "xlm", "xls", "xlsb", "xlsm", "xlsx", "xlt", "xltm", "xltx", "xlw", "xsf", "xsn"};
        _log = LogFactoryUtil.getLog(DLImpl.class);
        _allMediaGalleryMimeTypes = new TreeSet<String>(){
            {
                this.add("application/vnd+liferay.video.external.shortcut+html");
                this.addAll(SetUtil.fromArray((Object[])PropsUtil.getArray((String)"dl.file.entry.preview.audio.mime.types")));
                this.addAll(SetUtil.fromArray((Object[])PropsUtil.getArray((String)"dl.file.entry.preview.video.mime.types")));
                this.addAll(SetUtil.fromArray((Object[])PropsUtil.getArray((String)"dl.file.entry.preview.image.mime.types")));
                this.add("image/svg+xml");
            }
        };
        _fileIcons = new HashSet<String>(){
            {
                String[] fileIcons = null;
                try {
                    fileIcons = PropsUtil.getArray((String)"dl.file.icons");
                }
                catch (Exception exception) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)exception);
                    }
                    fileIcons = new String[]{""};
                }
                for (int i = 0; i < fileIcons.length; ++i) {
                    if ("*".equals(fileIcons[i])) continue;
                    String extension = fileIcons[i];
                    if (extension.length() > 0) {
                        extension = extension.substring(1);
                    }
                    this.add(extension);
                }
            }
        };
        _genericNames = new HashMap<String, String>();
        _trashHelperSnapshot = new Snapshot(DLImpl.class, TrashHelper.class);
        for (String genericName : genericNames = PropsUtil.getArray((String)"dl.file.generic.names")) {
            DLImpl._populateGenericNamesMap(genericName);
        }
    }
}

