/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.service.SocialActivityLocalService;
import com.liferay.social.kernel.service.SocialActivityLocalServiceUtil;
import com.liferay.social.kernel.service.persistence.SocialActivityFinder;
import com.liferay.social.kernel.service.persistence.SocialActivityPersistence;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;

public abstract class SocialActivityLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements IdentifiableOSGiService,
SocialActivityLocalService {
    @BeanReference(type=SocialActivityLocalService.class)
    protected SocialActivityLocalService socialActivityLocalService;
    @BeanReference(type=SocialActivityPersistence.class)
    protected SocialActivityPersistence socialActivityPersistence;
    @BeanReference(type=SocialActivityFinder.class)
    protected SocialActivityFinder socialActivityFinder;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(SocialActivityLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public SocialActivity addSocialActivity(SocialActivity socialActivity) {
        socialActivity.setNew(true);
        return (SocialActivity)this.socialActivityPersistence.update((BaseModel)socialActivity);
    }

    @Transactional(enabled=false)
    public SocialActivity createSocialActivity(long activityId) {
        return this.socialActivityPersistence.create(activityId);
    }

    @Indexable(type=IndexableType.DELETE)
    public SocialActivity deleteSocialActivity(long activityId) throws PortalException {
        return this.socialActivityPersistence.remove(activityId);
    }

    @Indexable(type=IndexableType.DELETE)
    public SocialActivity deleteSocialActivity(SocialActivity socialActivity) {
        return (SocialActivity)this.socialActivityPersistence.remove((BaseModel)socialActivity);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.socialActivityPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(SocialActivity.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.socialActivityPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.socialActivityPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.socialActivityPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.socialActivityPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.socialActivityPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public SocialActivity fetchSocialActivity(long activityId) {
        return this.socialActivityPersistence.fetchByPrimaryKey(activityId);
    }

    public SocialActivity getSocialActivity(long activityId) throws PortalException {
        return this.socialActivityPersistence.findByPrimaryKey(activityId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.socialActivityLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(SocialActivity.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("activityId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.socialActivityLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(SocialActivity.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("activityId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.socialActivityLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(SocialActivity.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("activityId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.socialActivityPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement SocialActivityLocalServiceImpl#deleteSocialActivity(SocialActivity) to avoid orphaned data");
        }
        return this.socialActivityLocalService.deleteSocialActivity((SocialActivity)persistedModel);
    }

    public BasePersistence<SocialActivity> getBasePersistence() {
        return this.socialActivityPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.socialActivityPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<SocialActivity> getSocialActivities(int start, int end) {
        return this.socialActivityPersistence.findAll(start, end);
    }

    public int getSocialActivitiesCount() {
        return this.socialActivityPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public SocialActivity updateSocialActivity(SocialActivity socialActivity) {
        return (SocialActivity)this.socialActivityPersistence.update((BaseModel)socialActivity);
    }

    public SocialActivityLocalService getSocialActivityLocalService() {
        return this.socialActivityLocalService;
    }

    public void setSocialActivityLocalService(SocialActivityLocalService socialActivityLocalService) {
        this.socialActivityLocalService = socialActivityLocalService;
    }

    public SocialActivityPersistence getSocialActivityPersistence() {
        return this.socialActivityPersistence;
    }

    public void setSocialActivityPersistence(SocialActivityPersistence socialActivityPersistence) {
        this.socialActivityPersistence = socialActivityPersistence;
    }

    public SocialActivityFinder getSocialActivityFinder() {
        return this.socialActivityFinder;
    }

    public void setSocialActivityFinder(SocialActivityFinder socialActivityFinder) {
        this.socialActivityFinder = socialActivityFinder;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public void afterPropertiesSet() {
        SocialActivityLocalServiceUtil.setService((SocialActivityLocalService)this.socialActivityLocalService);
    }

    public void destroy() {
        SocialActivityLocalServiceUtil.setService(null);
    }

    public String getOSGiServiceIdentifier() {
        return SocialActivityLocalService.class.getName();
    }

    public CTPersistence<SocialActivity> getCTPersistence() {
        return this.socialActivityPersistence;
    }

    public Class<SocialActivity> getModelClass() {
        return SocialActivity.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<SocialActivity>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.socialActivityPersistence);
    }

    protected String getModelClassName() {
        return SocialActivity.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.socialActivityPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

