/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.social.service.base.SocialActivityInterpreterLocalServiceBaseImpl;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityFeedEntry;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import com.liferay.social.kernel.model.SocialActivitySet;
import com.liferay.social.kernel.model.impl.SocialActivityInterpreterImpl;
import com.liferay.social.kernel.model.impl.SocialRequestInterpreterImpl;
import com.liferay.social.kernel.service.SocialActivityLocalService;
import com.liferay.social.kernel.service.SocialActivitySetLocalService;
import com.liferay.social.kernel.service.persistence.SocialActivityPersistence;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class SocialActivityInterpreterLocalServiceImpl
extends SocialActivityInterpreterLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(SocialActivityInterpreterLocalServiceImpl.class);
    private final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private ServiceTrackerMap<String, List<SocialActivityInterpreter>> _serviceTrackerMap;
    @BeanReference(type=SocialActivityLocalService.class)
    private SocialActivityLocalService _socialActivityLocalService;
    @BeanReference(type=SocialActivityPersistence.class)
    private SocialActivityPersistence _socialActivityPersistence;
    @BeanReference(type=SocialActivitySetLocalService.class)
    private SocialActivitySetLocalService _socialActivitySetLocalService;

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)this._bundleContext, SocialActivityInterpreter.class, (String)"(javax.portlet.name=*)", (ServiceReferenceMapper)ServiceReferenceMapperFactory.createFromFunction((BundleContext)this._bundleContext, SocialActivityInterpreter::getSelector), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<SocialActivityInterpreter, SocialActivityInterpreter>(){

            public SocialActivityInterpreter addingService(ServiceReference<SocialActivityInterpreter> serviceReference) {
                SocialActivityInterpreter activityInterpreter = (SocialActivityInterpreter)SocialActivityInterpreterLocalServiceImpl.this._bundleContext.getService(serviceReference);
                if (!(activityInterpreter instanceof SocialRequestInterpreterImpl)) {
                    String portletId = (String)serviceReference.getProperty("javax.portlet.name");
                    activityInterpreter = new SocialActivityInterpreterImpl(portletId, activityInterpreter);
                }
                return activityInterpreter;
            }

            public void modifiedService(ServiceReference<SocialActivityInterpreter> serviceReference, SocialActivityInterpreter socialActivityInterpreter) {
            }

            public void removedService(ServiceReference<SocialActivityInterpreter> serviceReference, SocialActivityInterpreter socialActivityInterpreter) {
                SocialActivityInterpreterLocalServiceImpl.this._bundleContext.ungetService(serviceReference);
            }
        });
    }

    @Override
    public void destroy() {
        super.destroy();
        this._serviceTrackerMap.close();
    }

    public Map<String, List<SocialActivityInterpreter>> getActivityInterpreters() {
        HashMap<String, List<SocialActivityInterpreter>> map = new HashMap<String, List<SocialActivityInterpreter>>();
        for (String selector : this._serviceTrackerMap.keySet()) {
            map.put(selector, (List)this._serviceTrackerMap.getService((Object)selector));
        }
        return map;
    }

    public List<SocialActivityInterpreter> getActivityInterpreters(String selector) {
        return (List)this._serviceTrackerMap.getService((Object)selector);
    }

    public SocialActivityFeedEntry interpret(String selector, SocialActivity activity, ServiceContext serviceContext) {
        List activityInterpreters;
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        if (httpServletRequest == null) {
            return null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            if (activity.getUserId() == themeDisplay.getGuestUserId()) {
                return null;
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        if (activity.getMirrorActivityId() > 0L) {
            SocialActivity mirrorActivity;
            block10: {
                mirrorActivity = null;
                try {
                    mirrorActivity = this._socialActivityLocalService.getActivity(activity.getMirrorActivityId());
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block10;
                    _log.debug((Throwable)exception);
                }
            }
            if (mirrorActivity != null) {
                activity = mirrorActivity;
            }
        }
        if ((activityInterpreters = (List)this._serviceTrackerMap.getService((Object)selector)) == null) {
            return null;
        }
        String className = PortalUtil.getClassName((long)activity.getClassNameId());
        for (SocialActivityInterpreter activityInterpreter : activityInterpreters) {
            SocialActivityFeedEntry activityFeedEntry;
            SocialActivityInterpreterImpl socialActivityInterpreterImpl = (SocialActivityInterpreterImpl)activityInterpreter;
            if (!socialActivityInterpreterImpl.hasClassName(className) || (activityFeedEntry = socialActivityInterpreterImpl.interpret(activity, serviceContext)) == null) continue;
            activityFeedEntry.setPortletId(socialActivityInterpreterImpl.getPortletId());
            return activityFeedEntry;
        }
        return null;
    }

    public SocialActivityFeedEntry interpret(String selector, SocialActivitySet activitySet, ServiceContext serviceContext) {
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        if (httpServletRequest == null) {
            return null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            if (activitySet.getUserId() == themeDisplay.getGuestUserId()) {
                return null;
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        List activityInterpreters = (List)this._serviceTrackerMap.getService((Object)selector);
        if (activityInterpreters == null) {
            return null;
        }
        String className = PortalUtil.getClassName((long)activitySet.getClassNameId());
        for (SocialActivityInterpreter activityInterpreter : activityInterpreters) {
            SocialActivityFeedEntry activityFeedEntry;
            SocialActivityInterpreterImpl socialActivityInterpreterImpl = (SocialActivityInterpreterImpl)activityInterpreter;
            if (!socialActivityInterpreterImpl.hasClassName(className) || (activityFeedEntry = socialActivityInterpreterImpl.interpret(activitySet, serviceContext)) == null) continue;
            activityFeedEntry.setPortletId(socialActivityInterpreterImpl.getPortletId());
            return activityFeedEntry;
        }
        return null;
    }

    public void updateActivitySet(long activityId) throws PortalException {
        if (!PropsValues.SOCIAL_ACTIVITY_SETS_BUNDLING_ENABLED) {
            this._socialActivitySetLocalService.addActivitySet(activityId);
            return;
        }
        List activityInterpreters = (List)this._serviceTrackerMap.getService((Object)PropsValues.SOCIAL_ACTIVITY_SETS_SELECTOR);
        if (activityInterpreters != null) {
            SocialActivity activity = this._socialActivityPersistence.findByPrimaryKey(activityId);
            String className = PortalUtil.getClassName((long)activity.getClassNameId());
            for (SocialActivityInterpreter activityInterpreter : activityInterpreters) {
                SocialActivityInterpreterImpl socialActivityInterpreterImpl = (SocialActivityInterpreterImpl)activityInterpreter;
                if (!socialActivityInterpreterImpl.hasClassName(className)) continue;
                socialActivityInterpreterImpl.updateActivitySet(activityId);
                return;
            }
        }
    }
}

