/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.key;

import com.liferay.petra.nio.CharsetEncoderUtil;
import com.liferay.portal.cache.key.BaseCacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCache;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.security.MessageDigest;

public class MessageDigestCacheKeyGenerator
extends BaseCacheKeyGenerator {
    private final String _algorithm;
    private final String _charsetName;

    public MessageDigestCacheKeyGenerator(String algorithm) {
        this(algorithm, "UTF-8");
    }

    public MessageDigestCacheKeyGenerator(String algorithm, String charsetName) {
        this._algorithm = algorithm;
        this._charsetName = charsetName;
    }

    @Override
    public CacheKeyGenerator clone() {
        return new MessageDigestCacheKeyGenerator(this._algorithm, this._charsetName);
    }

    @Deprecated
    public Serializable getCacheKey(StringBundler sb) {
        return this.getCacheKey(sb.getStrings(), sb.index());
    }

    public Serializable getCacheKey(String key) {
        return this.getCacheKey(new String[]{key}, 1);
    }

    public Serializable getCacheKey(String[] keys) {
        return this.getCacheKey(keys, keys.length);
    }

    public Serializable getCacheKey(com.liferay.petra.string.StringBundler sb) {
        return this.getCacheKey(sb.getStrings(), sb.index());
    }

    protected Serializable getCacheKey(String[] keys, int length) {
        try {
            ThreadLocalCache threadLocalCache = ThreadLocalCacheManager.getThreadLocalCache((Lifecycle)Lifecycle.ETERNAL, (Serializable)((Object)MessageDigestCacheKeyGenerator.class.getName()));
            MessageDigest messageDigest = (MessageDigest)threadLocalCache.get(this._algorithm);
            if (messageDigest == null) {
                messageDigest = MessageDigest.getInstance(this._algorithm);
                threadLocalCache.put(this._algorithm, (Object)messageDigest);
            }
            CharsetEncoder charsetEncoder = CharsetEncoderUtil.getCharsetEncoder((String)this._charsetName);
            for (int i = 0; i < length; ++i) {
                messageDigest.update(charsetEncoder.encode(CharBuffer.wrap(keys[i])));
            }
            return StringUtil.bytesToHexString((byte[])messageDigest.digest());
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

