/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto;

import com.liferay.portal.deploy.auto.ModuleAutoDeployer;
import com.liferay.portal.deploy.auto.PluginAutoDeployListenerHelper;
import com.liferay.portal.deploy.auto.ThreadSafeAutoDeployer;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployer;
import com.liferay.portal.kernel.deploy.auto.BaseAutoDeployListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class ModuleAutoDeployListener
extends BaseAutoDeployListener {
    protected AutoDeployer buildAutoDeployer() {
        return new ThreadSafeAutoDeployer(new ModuleAutoDeployer());
    }

    protected String getPluginPathInfoMessage(File file) {
        return "Copied module for " + file.getPath();
    }

    protected String getSuccessMessage(File file) {
        return "Module for " + file.getPath() + " copied successfully";
    }

    protected boolean isDeployable(File file) throws AutoDeployException {
        return this.isModule(file);
    }

    protected boolean isModule(File file) throws AutoDeployException {
        PluginAutoDeployListenerHelper pluginAutoDeployListenerHelper = new PluginAutoDeployListenerHelper(file);
        if (!pluginAutoDeployListenerHelper.isJarFile()) {
            return false;
        }
        Manifest manifest = null;
        try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));){
            manifest = jarInputStream.getManifest();
        }
        catch (IOException ioException) {
            throw new AutoDeployException((Throwable)ioException);
        }
        if (manifest == null) {
            return false;
        }
        Attributes attributes = manifest.getMainAttributes();
        String bundleSymbolicName = attributes.getValue("Bundle-SymbolicName");
        if (bundleSymbolicName == null) {
            return false;
        }
        int index = bundleSymbolicName.indexOf(59);
        if (index != -1) {
            bundleSymbolicName = bundleSymbolicName.substring(0, index);
        }
        return !bundleSymbolicName.isEmpty();
    }
}

