/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.petra.log4j.Log4JUtil;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.service.ServiceComponentLocalServiceUtil;
import com.liferay.portal.kernel.service.configuration.ServiceComponentConfiguration;
import com.liferay.portal.kernel.service.configuration.servlet.ServletServiceContextComponentConfiguration;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.plugin.PluginPackageUtil;
import com.liferay.util.portlet.PortletProps;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;
import javax.servlet.ServletContext;

public class PluginPackageHotDeployListener
extends BaseHotDeployListener {
    public static final String SERVICE_BUILDER_PROPERTIES = "SERVICE_BUILDER_PROPERTIES";
    private static final Log _log = LogFactoryUtil.getLog(PluginPackageHotDeployListener.class);

    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable throwable) {
            this.throwHotDeployException(hotDeployEvent, "Error registering plugins for ", throwable);
        }
    }

    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable throwable) {
            this.throwHotDeployException(hotDeployEvent, "Error unregistering plugins for ", throwable);
        }
    }

    protected void destroyServiceComponent(ServiceComponentConfiguration serviceComponentConfiguration, ClassLoader classLoader) throws Exception {
        ServiceComponentLocalServiceUtil.destroyServiceComponent((ServiceComponentConfiguration)serviceComponentConfiguration, (ClassLoader)classLoader);
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        PluginPackage pluginPackage;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((pluginPackage = PluginPackageUtil.readPluginPackageServletContext(servletContext)) == null) {
            return;
        }
        if (servletContext.getResource("/WEB-INF/liferay-theme-loader.xml") != null) {
            PluginPackageUtil.registerInstalledPluginPackage(pluginPackage);
            return;
        }
        pluginPackage.setContext(servletContextName);
        hotDeployEvent.setPluginPackage(pluginPackage);
        PluginPackageUtil.registerInstalledPluginPackage(pluginPackage);
        ClassLoader classLoader = hotDeployEvent.getContextClassLoader();
        this.initLogger(classLoader);
        this.initPortletProps(classLoader);
        this.initServiceComponent(servletContext, classLoader);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Plugin package " + pluginPackage.getModuleId() + " registered successfully. It is now ready to be used."));
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        PluginPackage pluginPackage;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking undeploy for " + servletContextName));
        }
        if ((pluginPackage = PluginPackageUtil.readPluginPackageServletContext(servletContext)) == null) {
            return;
        }
        hotDeployEvent.setPluginPackage(pluginPackage);
        PluginPackageUtil.unregisterInstalledPluginPackage(pluginPackage);
        ServletContextPool.remove((String)servletContextName);
        this.destroyServiceComponent((ServiceComponentConfiguration)new ServletServiceContextComponentConfiguration(servletContext), hotDeployEvent.getContextClassLoader());
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Plugin package " + pluginPackage.getModuleId() + " unregistered successfully"));
        }
    }

    @Deprecated
    protected URL getPortalCacheConfigurationURL(Configuration configuration, ClassLoader classLoader, String configLocation) {
        String cacheConfigurationLocation = configuration.get(configLocation);
        if (Validator.isNull((String)cacheConfigurationLocation)) {
            return null;
        }
        return classLoader.getResource(cacheConfigurationLocation);
    }

    protected void initLogger(ClassLoader classLoader) {
        Log4JUtil.configureLog4J((URL)classLoader.getResource("META-INF/portal-log4j.xml"));
    }

    protected void initPortletProps(ClassLoader classLoader) throws Exception {
        if (classLoader.getResourceAsStream("portlet.properties") == null) {
            return;
        }
        Class<?> clazz = classLoader.loadClass(PortletProps.class.getName());
        Method method = clazz.getMethod("get", String.class);
        method.invoke(null, "init");
    }

    protected void initServiceComponent(ServletContext servletContext, ClassLoader classLoader) throws Exception {
        Configuration serviceBuilderPropertiesConfiguration = null;
        try {
            serviceBuilderPropertiesConfiguration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"service");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to read service.properties", (Throwable)exception);
            }
            return;
        }
        Properties serviceBuilderProperties = serviceBuilderPropertiesConfiguration.getProperties();
        if (serviceBuilderProperties.isEmpty()) {
            return;
        }
        servletContext.setAttribute(SERVICE_BUILDER_PROPERTIES, (Object)serviceBuilderProperties);
        String buildNamespace = GetterUtil.getString((String)serviceBuilderProperties.getProperty("build.namespace"));
        long buildNumber = GetterUtil.getLong((String)serviceBuilderProperties.getProperty("build.number"));
        long buildDate = GetterUtil.getLong((String)serviceBuilderProperties.getProperty("build.date"));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Build namespace " + buildNamespace));
            _log.debug((Object)("Build number " + buildNumber));
            _log.debug((Object)("Build date " + buildDate));
        }
        if (Validator.isNull((String)buildNamespace)) {
            return;
        }
        ServiceComponentLocalServiceUtil.initServiceComponent((ServiceComponentConfiguration)new ServletServiceContextComponentConfiguration(servletContext), (ClassLoader)classLoader, (String)buildNamespace, (long)buildNumber, (long)buildDate);
    }
}

