/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.worker;

import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessException;
import com.liferay.portal.fabric.netty.handlers.NettyChannelAttributes;
import com.liferay.portal.fabric.netty.rpc.ChannelThreadLocal;
import com.liferay.portal.fabric.netty.rpc.RPCCallable;
import com.liferay.portal.fabric.netty.util.NettyUtil;
import com.liferay.portal.fabric.worker.FabricWorker;
import io.netty.channel.Channel;
import java.io.Serializable;

public class NettyFabricWorkerBridgeRPCCallable<T extends Serializable>
implements RPCCallable<T> {
    private static final long serialVersionUID = 1L;
    private final long _id;
    private final ProcessCallable<T> _processCallable;
    private final long _rpcRelayTimeout;

    public NettyFabricWorkerBridgeRPCCallable(long id, ProcessCallable<T> processCallable, long rpcRelayTimeout) {
        this._id = id;
        this._processCallable = processCallable;
        this._rpcRelayTimeout = rpcRelayTimeout;
    }

    @Override
    public NoticeableFuture<T> call() throws ProcessException {
        Channel channel = ChannelThreadLocal.getChannel();
        FabricWorker fabricWorker = NettyChannelAttributes.getFabricWorker(channel, this._id);
        if (fabricWorker == null) {
            throw new ProcessException("Unable to locate fabric worker with ID " + this._id);
        }
        NoticeableFuture noticeableFuture = fabricWorker.write(this._processCallable);
        NettyUtil.scheduleCancellation(channel, noticeableFuture, this._rpcRelayTimeout);
        return noticeableFuture;
    }
}

