/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository;

import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.capabilities.BulkOperationCapability;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.capabilities.CommentCapability;
import com.liferay.portal.kernel.repository.capabilities.DynamicCapability;
import com.liferay.portal.kernel.repository.capabilities.FileEntryTypeCapability;
import com.liferay.portal.kernel.repository.capabilities.PortalCapabilityLocator;
import com.liferay.portal.kernel.repository.capabilities.ProcessorCapability;
import com.liferay.portal.kernel.repository.capabilities.RelatedModelCapability;
import com.liferay.portal.kernel.repository.capabilities.SyncCapability;
import com.liferay.portal.kernel.repository.capabilities.ThumbnailCapability;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.capabilities.WorkflowCapability;
import com.liferay.portal.kernel.repository.model.FileContentReference;
import com.liferay.portal.kernel.repository.model.ModelValidator;
import com.liferay.portal.kernel.repository.registry.BaseRepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.CapabilityRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.RepositoryFactoryRegistry;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.repository.liferayrepository.ModelValidatorLocalRepositoryWrapper;
import com.liferay.portal.repository.liferayrepository.ModelValidatorRepositoryWrapper;
import com.liferay.portal.util.PropsValues;
import java.util.function.BiFunction;

public class LiferayRepositoryDefiner
extends BaseRepositoryDefiner {
    public static final String CLASS_NAME = LiferayRepository.class.getName();
    private final PortalCapabilityLocator _portalCapabilityLocator;
    private RepositoryFactory _repositoryFactory;

    public static BiFunction<PortalCapabilityLocator, RepositoryFactory, RepositoryDefiner> getFactoryBiFunction() {
        return LiferayRepositoryDefiner::new;
    }

    public LiferayRepositoryDefiner(PortalCapabilityLocator portalCapabilityLocator, RepositoryFactory repositoryFactory) {
        this._portalCapabilityLocator = portalCapabilityLocator;
        this._repositoryFactory = new LiferayRepositoryFactoryWrapper(repositoryFactory);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean isExternalRepository() {
        return false;
    }

    public void registerCapabilities(CapabilityRegistry<DocumentRepository> capabilityRegistry) {
        DocumentRepository documentRepository = (DocumentRepository)capabilityRegistry.getTarget();
        capabilityRegistry.addExportedCapability(BulkOperationCapability.class, (Capability)this._portalCapabilityLocator.getBulkOperationCapability(documentRepository));
        if (PropsValues.DL_FILE_ENTRY_COMMENTS_ENABLED) {
            capabilityRegistry.addExportedCapability(CommentCapability.class, (Capability)this._portalCapabilityLocator.getCommentCapability(documentRepository));
        }
        capabilityRegistry.addExportedCapability(FileEntryTypeCapability.class, (Capability)this._portalCapabilityLocator.getFileEntryTypeCapability());
        capabilityRegistry.addExportedCapability(RelatedModelCapability.class, (Capability)this._portalCapabilityLocator.getRelatedModelCapability(documentRepository));
        capabilityRegistry.addExportedCapability(ThumbnailCapability.class, (Capability)this._portalCapabilityLocator.getThumbnailCapability(documentRepository));
        capabilityRegistry.addExportedCapability(TrashCapability.class, (Capability)this._portalCapabilityLocator.getTrashCapability(documentRepository));
        capabilityRegistry.addExportedCapability(WorkflowCapability.class, (Capability)this._portalCapabilityLocator.getWorkflowCapability(documentRepository, WorkflowCapability.OperationMode.FULL));
        capabilityRegistry.addSupportedCapability(DynamicCapability.class, (Capability)this._portalCapabilityLocator.getDynamicCapability(documentRepository, this.getClassName()));
        capabilityRegistry.addSupportedCapability(ProcessorCapability.class, (Capability)this._portalCapabilityLocator.getProcessorCapability(documentRepository, ProcessorCapability.ResourceGenerationStrategy.REUSE));
        capabilityRegistry.addSupportedCapability(SyncCapability.class, (Capability)this._portalCapabilityLocator.getSyncCapability(documentRepository));
    }

    public void registerRepositoryFactory(RepositoryFactoryRegistry repositoryFactoryRegistry) {
        repositoryFactoryRegistry.setRepositoryFactory(this._repositoryFactory);
    }

    private static class LiferayRepositoryFactoryWrapper
    implements RepositoryFactory {
        private static final ModelValidator<FileContentReference> _modelValidator = fileContentReference -> {
            if (Validator.isNotNull((String)fileContentReference.getSourceFileName())) {
                DLValidatorUtil.validateFileName((String)fileContentReference.getSourceFileName());
            }
            if (fileContentReference.getFileEntryId() == 0L || Validator.isNotNull((String)fileContentReference.getSourceFileName())) {
                DLValidatorUtil.validateFileExtension((String)fileContentReference.getSourceFileName());
                DLValidatorUtil.validateSourceFileExtension((String)fileContentReference.getExtension(), (String)fileContentReference.getSourceFileName());
            }
            DLValidatorUtil.validateFileSize((String)fileContentReference.getSourceFileName(), (long)fileContentReference.getSize());
        };
        private final RepositoryFactory _repositoryFactory;

        public LiferayRepositoryFactoryWrapper(RepositoryFactory repositoryFactory) {
            this._repositoryFactory = repositoryFactory;
        }

        public LocalRepository createLocalRepository(long repositoryId) throws PortalException {
            return new ModelValidatorLocalRepositoryWrapper(this._repositoryFactory.createLocalRepository(repositoryId), _modelValidator);
        }

        public Repository createRepository(long repositoryId) throws PortalException {
            return new ModelValidatorRepositoryWrapper(this._repositoryFactory.createRepository(repositoryId), _modelValidator);
        }
    }
}

