/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.security.auth.AuthenticatedUserUUIDStoreUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.servlet.PortalSessionContext;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpSession;

public class PortalSessionDestroyer
extends BasePortalLifecycle {
    private static final Log _log = LogFactoryUtil.getLog(PortalSessionDestroyer.class);
    private final HttpSession _httpSession;

    public PortalSessionDestroyer(HttpSession httpSession) {
        this._httpSession = httpSession;
        this.registerPortalLifecycle(2);
    }

    protected void doPortalDestroy() {
    }

    protected void doPortalInit() {
        PortalSessionContext.remove((String)this._httpSession.getId());
        try {
            String userUUID;
            Long userIdObj = (Long)this._httpSession.getAttribute("USER_ID");
            if (userIdObj == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"User id is not in the session");
                }
                return;
            }
            if (PropsValues.LIVE_USERS_ENABLED) {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                ClusterNode clusterNode = ClusterExecutorUtil.getLocalClusterNode();
                if (clusterNode != null) {
                    jsonObject.put("clusterNodeId", clusterNode.getClusterNodeId());
                }
                jsonObject.put("command", "signOut");
                long userId = userIdObj;
                long companyId = CompanyLocalServiceUtil.getCompanyIdByUserId((long)userId);
                jsonObject.put("companyId", companyId).put("sessionId", this._httpSession.getId()).put("userId", userId);
                MessageBusUtil.sendMessage((String)"liferay/live_users", (Object)jsonObject.toString());
            }
            if (PropsValues.AUTH_USER_UUID_STORE_ENABLED && Validator.isNotNull((String)(userUUID = (String)this._httpSession.getAttribute("USER_UUID")))) {
                AuthenticatedUserUUIDStoreUtil.unregister((String)userUUID);
            }
        }
        catch (IllegalStateException illegalStateException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Please upgrade to a Servlet 2.4 compliant container", (Throwable)illegalStateException);
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        try {
            EventsProcessorUtil.process("servlet.session.destroy.events", PropsValues.SERVLET_SESSION_DESTROY_EVENTS, this._httpSession);
        }
        catch (ActionException actionException) {
            _log.error((Object)actionException, (Throwable)actionException);
        }
    }
}

