/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.petra.xml.Dom4jUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.webdav.methods.Method;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.webdav.InvalidRequestException;
import com.liferay.portal.webdav.methods.BasePropMethodImpl;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PropfindMethodImpl
extends BasePropMethodImpl
implements Method {
    private static final Log _log = LogFactoryUtil.getLog(PropfindMethodImpl.class);

    public int process(WebDAVRequest webDAVRequest) throws WebDAVException {
        try {
            return this.writeResponseXML(webDAVRequest, this.getProps(webDAVRequest));
        }
        catch (InvalidRequestException invalidRequestException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)invalidRequestException, (Throwable)((Object)invalidRequestException));
            }
            return 400;
        }
        catch (Exception exception) {
            throw new WebDAVException((Throwable)exception);
        }
    }

    protected Set<QName> generateProps(Set<QName> props) {
        props.add(DISPLAYNAME);
        props.add(GETCONTENTLENGTH);
        props.add(GETCONTENTTYPE);
        props.add(GETLASTMODIFIED);
        props.add(LOCKDISCOVERY);
        props.add(RESOURCETYPE);
        return props;
    }

    protected Set<QName> getProps(WebDAVRequest webDAVRequest) throws InvalidRequestException {
        try {
            Document document;
            Element rootElement;
            HashSet<QName> props = new HashSet<QName>();
            HttpServletRequest httpServletRequest = webDAVRequest.getHttpServletRequest();
            String xml = new String(FileUtil.getBytes((InputStream)httpServletRequest.getInputStream()));
            if (Validator.isNull((String)xml)) {
                return this.generateProps(props);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Request XML: \n" + Dom4jUtil.toString((String)xml, (String)"    ")));
            }
            if ((rootElement = (document = SAXReaderUtil.read((String)xml)).getRootElement()).element(ALLPROP.getName()) != null) {
                return this.generateProps(props);
            }
            Element propElement = rootElement.element("prop");
            List elements = propElement.elements();
            for (Element element : elements) {
                String prefix = element.getNamespacePrefix();
                String uri = element.getNamespaceURI();
                Namespace namespace = WebDAVUtil.createNamespace((String)prefix, (String)uri);
                props.add(SAXReaderUtil.createQName((String)element.getName(), (Namespace)namespace));
            }
            return props;
        }
        catch (Exception exception) {
            throw new InvalidRequestException(exception);
        }
    }
}

