/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.permission;

import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;

public class AssetVocabularyPermission {
    public static void check(PermissionChecker permissionChecker, AssetVocabulary vocabulary, String actionId) throws PortalException {
        if (!AssetVocabularyPermission.contains(permissionChecker, vocabulary, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AssetVocabulary.class.getName(), vocabulary.getVocabularyId(), new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long vocabularyId, String actionId) throws PortalException {
        if (!AssetVocabularyPermission.contains(permissionChecker, vocabularyId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AssetVocabulary.class.getName(), vocabularyId, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, AssetVocabulary vocabulary, String actionId) {
        if (permissionChecker.hasOwnerPermission(vocabulary.getCompanyId(), AssetVocabulary.class.getName(), vocabulary.getVocabularyId(), vocabulary.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(vocabulary.getGroupId(), AssetVocabulary.class.getName(), vocabulary.getVocabularyId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long vocabularyId, String actionId) throws PortalException {
        return AssetVocabularyPermission.contains(permissionChecker, AssetVocabularyLocalServiceUtil.getVocabulary((long)vocabularyId), actionId);
    }
}

