/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.pool.metrics;

import com.liferay.portal.dao.jdbc.pool.metrics.BaseConnectionPoolMetrics;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.lang.reflect.Method;

public class HikariConnectionPoolMetrics
extends BaseConnectionPoolMetrics {
    private final Object _dataSource;
    private final Method _getHikariPoolMXBeanMethod;
    private final Method _getPoolNameMethod;

    public HikariConnectionPoolMetrics(Object dataSource) throws ReflectiveOperationException {
        this._dataSource = dataSource;
        Class<?> clazz = dataSource.getClass();
        this._getPoolNameMethod = clazz.getMethod("getPoolName", new Class[0]);
        this._getHikariPoolMXBeanMethod = clazz.getMethod("getHikariPoolMXBean", new Class[0]);
    }

    public int getNumActive() {
        try {
            HikariPoolMXBean hikariPoolMXBean = (HikariPoolMXBean)this._getHikariPoolMXBeanMethod.invoke(this._dataSource, new Object[0]);
            return hikariPoolMXBean.getActiveConnections();
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public int getNumIdle() {
        try {
            HikariPoolMXBean hikariPoolMXBean = (HikariPoolMXBean)this._getHikariPoolMXBeanMethod.invoke(this._dataSource, new Object[0]);
            return hikariPoolMXBean.getIdleConnections();
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    @Override
    protected Object getDataSource() {
        return this._dataSource;
    }

    @Override
    protected String getPoolName() {
        try {
            return (String)this._getPoolNameMethod.invoke(this._dataSource, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

