/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.service.LayoutTemplateLocalServiceUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public class LayoutTemplateHotDeployListener
extends BaseHotDeployListener {
    private static final Log _log = LogFactoryUtil.getLog(LayoutTemplateHotDeployListener.class);
    private static final Map<String, List<LayoutTemplate>> _layoutTemplates = new HashMap<String, List<LayoutTemplate>>();

    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable throwable) {
            this.throwHotDeployException(hotDeployEvent, "Error registering layout templates for ", throwable);
        }
    }

    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable throwable) {
            this.throwHotDeployException(hotDeployEvent, "Error unregistering layout templates for ", throwable);
        }
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        String[] xmls;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((xmls = new String[]{StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/liferay-layout-templates.xml"))})[0] == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Registering layout templates for " + servletContextName));
        }
        List layoutTemplates = LayoutTemplateLocalServiceUtil.init((String)servletContextName, (ServletContext)servletContext, (String[])xmls, (PluginPackage)hotDeployEvent.getPluginPackage());
        _layoutTemplates.put(servletContextName, layoutTemplates);
        servletContext.setAttribute("PLUGIN_LAYOUT_TEMPLATES", (Object)layoutTemplates);
        if (_log.isInfoEnabled()) {
            if (layoutTemplates.size() == 1) {
                _log.info((Object)("1 layout template for " + servletContextName + " is available for use"));
            } else {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{layoutTemplates.size(), " layout templates for ", servletContextName, " are available for use"}));
            }
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        List<LayoutTemplate> layoutTemplates;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking undeploy for " + servletContextName));
        }
        if ((layoutTemplates = _layoutTemplates.remove(servletContextName)) == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Unregistering layout templates for " + servletContextName));
        }
        for (LayoutTemplate layoutTemplate : layoutTemplates) {
            try {
                LayoutTemplateLocalServiceUtil.uninstallLayoutTemplate((String)layoutTemplate.getLayoutTemplateId(), (boolean)layoutTemplate.isStandard());
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
        }
        if (_log.isInfoEnabled()) {
            if (layoutTemplates.size() == 1) {
                _log.info((Object)("1 layout template for " + servletContextName + " was unregistered"));
            } else {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{layoutTemplates.size(), " layout templates for ", servletContextName, " were unregistered"}));
            }
        }
    }
}

