/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric;

import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.reflect.ObjectGraphUtil;
import com.liferay.portal.fabric.repository.RepositoryHelperUtil;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FabricPathMappingVisitor
extends ObjectGraphUtil.AnnotatedFieldMappingVisitor {
    private final Map<Path, Path> _pathMap = new HashMap<Path, Path>();
    private final Path _remoteRepositoryPath;
    private final boolean _reverseMapping;

    public FabricPathMappingVisitor(Class<? extends Annotation> annotationClass, Path remoteRepositoryPath) {
        this(annotationClass, remoteRepositoryPath, false);
    }

    public FabricPathMappingVisitor(Class<? extends Annotation> annotationClass, Path remoteRepositoryPath, boolean reverseMapping) {
        super(Collections.singleton(ProcessCallable.class), Collections.singleton(annotationClass), Collections.singleton(File.class));
        this._remoteRepositoryPath = remoteRepositoryPath;
        this._reverseMapping = reverseMapping;
    }

    public Map<Path, Path> getPathMap() {
        return this._pathMap;
    }

    protected Object doMap(Field field, Object value) {
        File file = (File)value;
        Path path = file.toPath();
        Path mappedPath = RepositoryHelperUtil.getRepositoryFilePath(this._remoteRepositoryPath, path);
        if (this._reverseMapping) {
            this._pathMap.put(mappedPath, path);
        } else {
            this._pathMap.put(path, mappedPath);
        }
        return mappedPath.toFile();
    }
}

