/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.worker;

import com.liferay.petra.concurrent.BaseFutureListener;
import com.liferay.petra.concurrent.DefaultNoticeableFuture;
import com.liferay.petra.concurrent.FutureListener;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.portal.fabric.netty.rpc.RPCUtil;
import com.liferay.portal.fabric.netty.worker.NettyFabricWorkerBridgeRPCCallable;
import com.liferay.portal.fabric.netty.worker.NettyFabricWorkerProcessCallableExecutor;
import com.liferay.portal.fabric.repository.Repository;
import com.liferay.portal.fabric.status.FabricStatus;
import com.liferay.portal.fabric.status.RemoteFabricStatus;
import com.liferay.portal.fabric.worker.FabricWorker;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.Future;

public class NettyFabricWorkerStub<T extends Serializable>
implements FabricWorker<T> {
    private final Channel _channel;
    private final DefaultNoticeableFuture<T> _defaultNoticeableFuture = new DefaultNoticeableFuture();
    private final long _id;
    private final Map<Path, Path> _outputPathMap;
    private final Repository<Channel> _repository;
    private final long _rpcRelayTimeout;

    public NettyFabricWorkerStub(long id, Channel channel, Repository<Channel> repository, Map<Path, Path> outputPathMap, long rpcRelayTimeout) {
        if (channel == null) {
            throw new NullPointerException("Channel is null");
        }
        if (repository == null) {
            throw new NullPointerException("Repository is null");
        }
        if (outputPathMap == null) {
            throw new NullPointerException("Output path map is null");
        }
        this._id = id;
        this._channel = channel;
        this._repository = repository;
        this._outputPathMap = outputPathMap;
        this._rpcRelayTimeout = rpcRelayTimeout;
        final ChannelFuture channelFuture = this._channel.closeFuture();
        final ChannelFutureListener channelCloseListener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) {
                NettyFabricWorkerStub.this._defaultNoticeableFuture.cancel(true);
            }
        };
        channelFuture.addListener((GenericFutureListener)channelCloseListener);
        this._defaultNoticeableFuture.addFutureListener(new FutureListener<T>(){

            public void complete(Future<T> future) {
                channelFuture.removeListener((GenericFutureListener)channelCloseListener);
            }
        });
    }

    @Override
    public FabricStatus getFabricStatus() {
        return new RemoteFabricStatus(new NettyFabricWorkerProcessCallableExecutor(this._channel, this._id, this._rpcRelayTimeout));
    }

    public NoticeableFuture<T> getProcessNoticeableFuture() {
        return this._defaultNoticeableFuture;
    }

    public void setCancel() {
        this._defaultNoticeableFuture.cancel(true);
    }

    public void setException(Throwable throwable) {
        this._defaultNoticeableFuture.setException(throwable);
    }

    public void setResult(final T result) {
        NoticeableFuture<Map<Path, Path>> noticeableFuture = this._repository.getFiles(this._channel, this._outputPathMap, true);
        noticeableFuture.addFutureListener((FutureListener)new BaseFutureListener<Map<Path, Path>>(){

            public void completeWithCancel(Future<Map<Path, Path>> future) {
                NettyFabricWorkerStub.this._defaultNoticeableFuture.cancel(true);
            }

            public void completeWithException(Future<Map<Path, Path>> future, Throwable throwable) {
                NettyFabricWorkerStub.this._defaultNoticeableFuture.setException(throwable);
            }

            public void completeWithResult(Future<Map<Path, Path>> future, Map<Path, Path> map) {
                NettyFabricWorkerStub.this._defaultNoticeableFuture.set((Object)result);
            }
        });
    }

    public <V extends Serializable> NoticeableFuture<V> write(ProcessCallable<V> processCallable) {
        return RPCUtil.execute(this._channel, new NettyFabricWorkerBridgeRPCCallable<V>(this._id, processCallable, this._rpcRelayTimeout));
    }
}

