/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.jsonwebservice.JSONRPCRequest;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionParametersMap;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.upload.FileItem;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class JSONWebServiceActionParameters {
    private static final Log _log = LogFactoryUtil.getLog(JSONWebServiceActionParameters.class);
    private JSONRPCRequest _jsonRPCRequest;
    private final JSONWebServiceActionParametersMap _jsonWebServiceActionParameters = new JSONWebServiceActionParametersMap();
    private ServiceContext _serviceContext;

    public void collectAll(HttpServletRequest httpServletRequest, String parameterPath, JSONRPCRequest jsonRPCRequest, Map<String, Object> parameterMap) {
        block2: {
            this._jsonRPCRequest = jsonRPCRequest;
            try {
                this._serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        this._addDefaultParameters();
        this._collectDefaultsFromRequestAttributes(httpServletRequest);
        this._collectFromPath(parameterPath);
        this._collectFromRequestParameters(httpServletRequest);
        this._collectFromJSONRPCRequest(jsonRPCRequest);
        this._collectFromMap(parameterMap);
    }

    public List<Map.Entry<String, Object>> getInnerParameters(String baseName) {
        return this._jsonWebServiceActionParameters.getInnerParameters(baseName);
    }

    public JSONRPCRequest getJSONRPCRequest() {
        return this._jsonRPCRequest;
    }

    public Object getParameter(String name) {
        return this._jsonWebServiceActionParameters.get(name);
    }

    public String[] getParameterNames() {
        String[] names = new String[this._jsonWebServiceActionParameters.size()];
        int i = 0;
        Iterator iterator = this._jsonWebServiceActionParameters.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            names[i] = key = (String)iterator.next();
            ++i;
        }
        return names;
    }

    public String getParameterTypeName(String name) {
        return this._jsonWebServiceActionParameters.getParameterTypeName(name);
    }

    public ServiceContext getServiceContext() {
        return this._serviceContext;
    }

    public boolean includeDefaultParameters() {
        return this._jsonWebServiceActionParameters.includeDefaultParameters();
    }

    private void _addDefaultParameters() {
        this._jsonWebServiceActionParameters.put("serviceContext", (Object)Void.TYPE);
    }

    private void _collectDefaultsFromRequestAttributes(HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String attributeName = (String)enumeration.nextElement();
            Object value = httpServletRequest.getAttribute(attributeName);
            this._jsonWebServiceActionParameters.putDefaultParameter(attributeName, value);
        }
    }

    private void _collectFromJSONRPCRequest(JSONRPCRequest jsonRPCRequest) {
        if (jsonRPCRequest == null) {
            return;
        }
        Set<String> parameterNames = jsonRPCRequest.getParameterNames();
        for (String parameterName : parameterNames) {
            String value = jsonRPCRequest.getParameter(parameterName);
            parameterName = CamelCaseUtil.normalizeCamelCase((String)parameterName);
            this._jsonWebServiceActionParameters.put(parameterName, (Object)value);
        }
    }

    private void _collectFromMap(Map<String, Object> parameterMap) {
        if (parameterMap == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : parameterMap.entrySet()) {
            String parameterName = entry.getKey();
            this._jsonWebServiceActionParameters.put(parameterName, entry.getValue());
        }
    }

    private void _collectFromPath(String parameterPath) {
        if (parameterPath == null) {
            return;
        }
        if (parameterPath.startsWith("/")) {
            parameterPath = parameterPath.substring(1);
        }
        String[] parameterPathParts = StringUtil.split((String)parameterPath, (char)'/');
        int i = 0;
        while (i < parameterPathParts.length) {
            String name = parameterPathParts[i];
            if (name.length() == 0) {
                ++i;
                continue;
            }
            String value = null;
            if (name.startsWith("-")) {
                name = name.substring(1);
            } else if (!name.startsWith("+")) {
                if (++i >= parameterPathParts.length) {
                    throw new IllegalArgumentException("Missing value for parameter " + name);
                }
                value = parameterPathParts[i];
            }
            name = CamelCaseUtil.toCamelCase((String)name);
            this._jsonWebServiceActionParameters.put(name, (Object)value);
            ++i;
        }
    }

    private void _collectFromRequestParameters(HttpServletRequest httpServletRequest) {
        Map multipartParameterMap = null;
        HashSet parameterNames = new HashSet(Collections.list(httpServletRequest.getParameterNames()));
        if (httpServletRequest instanceof UploadServletRequest) {
            UploadServletRequest uploadServletRequest = (UploadServletRequest)httpServletRequest;
            multipartParameterMap = uploadServletRequest.getMultipartParameterMap();
            parameterNames.addAll(multipartParameterMap.keySet());
        }
        for (String parameterName : parameterNames) {
            Object value = null;
            if (multipartParameterMap != null && multipartParameterMap.containsKey(parameterName)) {
                FileItem[] fileItems = (FileItem[])multipartParameterMap.get(parameterName);
                File[] files = new File[fileItems.length];
                for (int i = 0; i < fileItems.length; ++i) {
                    File file;
                    block8: {
                        FileItem fileItem = fileItems[i];
                        file = fileItem.getStoreLocation();
                        if (fileItem.isInMemory()) {
                            try {
                                FileUtil.write((File)file, (InputStream)fileItem.getInputStream());
                            }
                            catch (IOException ioException) {
                                if (!_log.isWarnEnabled()) break block8;
                                _log.warn((Object)("Unable to write temporary file " + file.getAbsolutePath()), (Throwable)ioException);
                            }
                        }
                    }
                    files[i] = file;
                }
                value = files.length == 1 ? files[0] : files;
            } else {
                String[] parameterValues = httpServletRequest.getParameterValues(parameterName);
                value = parameterValues.length == 1 ? parameterValues[0] : parameterValues;
            }
            parameterName = CamelCaseUtil.normalizeCamelCase((String)parameterName);
            this._jsonWebServiceActionParameters.put(parameterName, value);
        }
    }
}

