/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PwdEncryptorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptor;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pwd.BasePasswordEncryptor;
import com.liferay.portal.util.PropsValues;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompositePasswordEncryptor
extends BasePasswordEncryptor
implements PasswordEncryptor {
    private static final Log _log = LogFactoryUtil.getLog(CompositePasswordEncryptor.class);
    private PasswordEncryptor _defaultAlgorithmPasswordEncryptor;
    private PasswordEncryptor _defaultPasswordEncryptor;
    private final Map<String, PasswordEncryptor> _passwordEncryptors = new HashMap<String, PasswordEncryptor>();

    public void afterPropertiesSet() {
        if (this._defaultAlgorithmPasswordEncryptor == null) {
            this._defaultAlgorithmPasswordEncryptor = this._select(this.getDefaultPasswordAlgorithmType());
        }
    }

    public String encrypt(String algorithm, String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        if (Validator.isNull((String)plainTextPassword)) {
            throw new PwdEncryptorException("Unable to encrypt blank password");
        }
        String legacyAlgorithm = PropsValues.PASSWORDS_ENCRYPTION_ALGORITHM_LEGACY;
        if (_log.isDebugEnabled() && Validator.isNotNull((String)legacyAlgorithm)) {
            if (Validator.isNull((String)encryptedPassword)) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Using legacy detection scheme for algorithm ", legacyAlgorithm, " with empty current password"}));
            } else {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Using legacy detection scheme for algorithm ", legacyAlgorithm, " with provided current password"}));
            }
        }
        boolean prependAlgorithm = true;
        if (Validator.isNotNull((String)encryptedPassword) && encryptedPassword.charAt(0) != '{') {
            algorithm = legacyAlgorithm;
            prependAlgorithm = false;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using legacy algorithm " + algorithm));
            }
        } else if (Validator.isNotNull((String)encryptedPassword) && encryptedPassword.charAt(0) == '{') {
            int index = encryptedPassword.indexOf(125);
            if (index > 0) {
                algorithm = encryptedPassword.substring(1, index);
                encryptedPassword = encryptedPassword.substring(index + 1);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Upgraded password to use algorithm " + algorithm));
            }
        }
        if (Validator.isNull((String)algorithm)) {
            algorithm = this.getDefaultPasswordAlgorithmType();
        }
        PasswordEncryptor passwordEncryptor = this._select(algorithm);
        String newEncryptedPassword = passwordEncryptor.encrypt(algorithm, plainTextPassword, encryptedPassword);
        if (!prependAlgorithm) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Generated password without algorithm prefix using " + algorithm));
            }
            return newEncryptedPassword;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Generated password with algorithm prefix using " + algorithm));
        }
        return StringBundler.concat((String[])new String[]{"{", this._getAlgorithmName(algorithm), "}", newEncryptedPassword});
    }

    public String[] getSupportedAlgorithmTypes() {
        throw new UnsupportedOperationException();
    }

    public void setDefaultPasswordEncryptor(PasswordEncryptor defaultPasswordEncryptor) {
        this._defaultPasswordEncryptor = defaultPasswordEncryptor;
    }

    public void setPasswordEncryptors(List<PasswordEncryptor> passwordEncryptors) {
        for (PasswordEncryptor passwordEncryptor : passwordEncryptors) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Registering " + passwordEncryptor));
            }
            Object[] supportedAlgorithmTypes = passwordEncryptor.getSupportedAlgorithmTypes();
            if (_log.isDebugEnabled()) {
                Class<?> clazz = passwordEncryptor.getClass();
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Registering ", StringUtil.merge((Object[])supportedAlgorithmTypes), " for ", clazz.getName()}));
            }
            for (String string : supportedAlgorithmTypes) {
                this._passwordEncryptors.put(string, passwordEncryptor);
            }
        }
    }

    private String _getAlgorithmName(String algorithm) {
        int index = algorithm.indexOf(47);
        if (index > 0) {
            return algorithm.substring(0, index);
        }
        return algorithm;
    }

    private PasswordEncryptor _select(String algorithm) {
        if (Validator.isNull((String)algorithm)) {
            throw new IllegalArgumentException("Invalid algorithm");
        }
        PasswordEncryptor passwordEncryptor = null;
        passwordEncryptor = algorithm.startsWith("BCRYPT") ? this._passwordEncryptors.get("BCRYPT") : (algorithm.startsWith("PBKDF2") ? this._passwordEncryptors.get("PBKDF2") : this._passwordEncryptors.get(algorithm));
        if (passwordEncryptor == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No password encryptor found for " + algorithm));
            }
            passwordEncryptor = this._defaultPasswordEncryptor;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Found ", ClassUtil.getClassName((Object)passwordEncryptor), " to encrypt password using ", algorithm}));
        }
        return passwordEncryptor;
    }
}

