/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.LayoutSetPrototypePermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.base.LayoutSetPrototypeServiceBaseImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutSetPrototypeServiceImpl
extends LayoutSetPrototypeServiceBaseImpl {
    public LayoutSetPrototype addLayoutSetPrototype(Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, boolean layoutsUpdateable, boolean readyForPropagation, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_LAYOUT_SET_PROTOTYPE");
        User user = this.getUser();
        return this.layoutSetPrototypeLocalService.addLayoutSetPrototype(user.getUserId(), user.getCompanyId(), nameMap, descriptionMap, active, layoutsUpdateable, readyForPropagation, serviceContext);
    }

    public LayoutSetPrototype addLayoutSetPrototype(Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, boolean layoutsUpdateable, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_LAYOUT_SET_PROTOTYPE");
        User user = this.getUser();
        return this.layoutSetPrototypeLocalService.addLayoutSetPrototype(user.getUserId(), user.getCompanyId(), nameMap, descriptionMap, active, layoutsUpdateable, serviceContext);
    }

    public LayoutSetPrototype addLayoutSetPrototype(String name, String description, boolean active, boolean layoutsUpdateable, boolean readyForPropagation, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_LAYOUT_SET_PROTOTYPE");
        Locale locale = LocaleUtil.getSiteDefault();
        User user = this.getUser();
        return this.layoutSetPrototypeLocalService.addLayoutSetPrototype(user.getUserId(), user.getCompanyId(), (Map)HashMapBuilder.put((Object)locale, (Object)name).build(), (Map)HashMapBuilder.put((Object)locale, (Object)description).build(), active, layoutsUpdateable, readyForPropagation, serviceContext);
    }

    public void deleteLayoutSetPrototype(long layoutSetPrototypeId) throws PortalException {
        LayoutSetPrototypePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutSetPrototypeId, (String)"DELETE");
        this.layoutSetPrototypeLocalService.deleteLayoutSetPrototype(layoutSetPrototypeId);
    }

    public void deleteNondefaultLayoutSetPrototypes(long companyId) throws PortalException {
        LayoutSetPrototypePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)0L, (String)"DELETE");
        this.layoutSetPrototypeLocalService.deleteNondefaultLayoutSetPrototypes(companyId);
    }

    public LayoutSetPrototype fetchLayoutSetPrototype(long layoutSetPrototypeId) throws PortalException {
        LayoutSetPrototypePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutSetPrototypeId, (String)"VIEW");
        return this.layoutSetPrototypeLocalService.fetchLayoutSetPrototype(layoutSetPrototypeId);
    }

    public LayoutSetPrototype getLayoutSetPrototype(long layoutSetPrototypeId) throws PortalException {
        LayoutSetPrototypePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutSetPrototypeId, (String)"VIEW");
        return this.layoutSetPrototypeLocalService.getLayoutSetPrototype(layoutSetPrototypeId);
    }

    public List<LayoutSetPrototype> getLayoutSetPrototypes(long companyId) throws PortalException {
        List layoutSetPrototypes = this.layoutSetPrototypePersistence.findByCompanyId(companyId);
        return this.filterLayoutSetPrototypes(layoutSetPrototypes);
    }

    public List<LayoutSetPrototype> search(long companyId, Boolean active, OrderByComparator<LayoutSetPrototype> orderByComparator) throws PortalException {
        List layoutSetPrototypes = this.layoutSetPrototypeLocalService.search(companyId, active, -1, -1, orderByComparator);
        return this.filterLayoutSetPrototypes(layoutSetPrototypes);
    }

    public LayoutSetPrototype updateLayoutSetPrototype(long layoutSetPrototypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, boolean layoutsUpdateable, boolean readyForPropagation, ServiceContext serviceContext) throws PortalException {
        LayoutSetPrototypePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutSetPrototypeId, (String)"UPDATE");
        return this.layoutSetPrototypeLocalService.updateLayoutSetPrototype(layoutSetPrototypeId, nameMap, descriptionMap, active, layoutsUpdateable, readyForPropagation, serviceContext);
    }

    public LayoutSetPrototype updateLayoutSetPrototype(long layoutSetPrototypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, boolean layoutsUpdateable, ServiceContext serviceContext) throws PortalException {
        LayoutSetPrototypePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutSetPrototypeId, (String)"UPDATE");
        return this.layoutSetPrototypeLocalService.updateLayoutSetPrototype(layoutSetPrototypeId, nameMap, descriptionMap, active, layoutsUpdateable, serviceContext);
    }

    public LayoutSetPrototype updateLayoutSetPrototype(long layoutSetPrototypeId, String settings) throws PortalException {
        LayoutSetPrototypePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutSetPrototypeId, (String)"UPDATE");
        return this.layoutSetPrototypeLocalService.updateLayoutSetPrototype(layoutSetPrototypeId, settings);
    }

    protected List<LayoutSetPrototype> filterLayoutSetPrototypes(List<LayoutSetPrototype> layoutSetPrototypes) throws PortalException {
        ArrayList<LayoutSetPrototype> filteredLayoutSetPrototypes = new ArrayList<LayoutSetPrototype>();
        PermissionChecker permissionChecker = this.getPermissionChecker();
        for (LayoutSetPrototype layoutSetPrototype : layoutSetPrototypes) {
            if (!LayoutSetPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)layoutSetPrototype.getLayoutSetPrototypeId(), (String)"VIEW")) continue;
            filteredLayoutSetPrototypes.add(layoutSetPrototype);
        }
        return filteredLayoutSetPrototypes;
    }
}

