/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.internal.service.util.PortalPreferencesCacheUtil;
import com.liferay.portal.kernel.model.PortalPreferenceValue;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.service.persistence.PortalPreferenceValuePersistence;
import com.liferay.portal.service.base.PortalPreferenceValueLocalServiceBaseImpl;
import com.liferay.portlet.PortalPreferenceKey;
import com.liferay.portlet.PortalPreferencesImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PortalPreferenceValueLocalServiceImpl
extends PortalPreferenceValueLocalServiceBaseImpl {
    public static Map<PortalPreferenceKey, String[]> getPreferenceMap(PortalPreferenceValuePersistence portalPreferenceValuePersistence, long portalPreferencesId, boolean useFinderCache) {
        Map<PortalPreferenceKey, String[]> preferenceMap = null;
        if (useFinderCache) {
            preferenceMap = PortalPreferencesCacheUtil.get(portalPreferencesId);
        }
        if (preferenceMap != null) {
            return preferenceMap;
        }
        Map<PortalPreferenceKey, List<PortalPreferenceValue>> portalPreferenceValuesMap = PortalPreferenceValueLocalServiceImpl.getPortalPreferenceValuesMap(portalPreferenceValuePersistence, portalPreferencesId, useFinderCache);
        preferenceMap = new HashMap<PortalPreferenceKey, String[]>();
        for (Map.Entry<PortalPreferenceKey, List<PortalPreferenceValue>> entry : portalPreferenceValuesMap.entrySet()) {
            List<PortalPreferenceValue> portalPreferenceValues = entry.getValue();
            String[] values = new String[portalPreferenceValues.size()];
            for (int i = 0; i < portalPreferenceValues.size(); ++i) {
                PortalPreferenceValue portalPreferenceValue = portalPreferenceValues.get(i);
                values[i] = portalPreferenceValue.getValue();
            }
            preferenceMap.put(entry.getKey(), values);
        }
        PortalPreferencesCacheUtil.put(portalPreferencesId, preferenceMap);
        return preferenceMap;
    }

    public PortalPreferences getPortalPreferences(com.liferay.portal.kernel.model.PortalPreferences portalPreferences, boolean signedIn) {
        Map<PortalPreferenceKey, String[]> preferenceMap = PortalPreferenceValueLocalServiceImpl.getPreferenceMap(this.portalPreferenceValuePersistence, portalPreferences.getPortalPreferencesId(), true);
        return new PortalPreferencesImpl(portalPreferences.getOwnerId(), portalPreferences.getOwnerType(), preferenceMap, signedIn);
    }

    protected static Map<PortalPreferenceKey, List<PortalPreferenceValue>> getPortalPreferenceValuesMap(PortalPreferenceValuePersistence portalPreferenceValuePersistence, long portalPreferencesId, boolean useFinderCache) {
        HashMap<PortalPreferenceKey, List<PortalPreferenceValue>> portalPreferenceValuesMap = new HashMap<PortalPreferenceKey, List<PortalPreferenceValue>>();
        for (PortalPreferenceValue portalPreferenceValue : portalPreferenceValuePersistence.findByPortalPreferencesId(portalPreferencesId, -1, -1, null, useFinderCache)) {
            List portalPreferenceValues = portalPreferenceValuesMap.computeIfAbsent(new PortalPreferenceKey(portalPreferenceValue.getNamespace(), portalPreferenceValue.getKey()), key -> new ArrayList(1));
            portalPreferenceValues.add(portalPreferenceValue);
        }
        return portalPreferenceValuesMap;
    }
}

