/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchReleaseException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.model.ReleaseConstants;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.upgrade.OlderVersionException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.ReleaseLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class ReleaseLocalServiceImpl
extends ReleaseLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ReleaseLocalServiceImpl.class);

    public Release addRelease(String servletContextName, int buildNumber) {
        Release release = null;
        if (servletContextName.equals("portal")) {
            release = this.releasePersistence.create(1L);
        } else {
            long releaseId = this.counterLocalService.increment();
            release = this.releasePersistence.create(releaseId);
        }
        Date date = new Date();
        release.setCreateDate(date);
        release.setModifiedDate(date);
        release.setServletContextName(servletContextName);
        release.setBuildNumber(buildNumber);
        if (servletContextName.equals("portal")) {
            release.setTestString(ReleaseConstants.TEST_STRING);
        }
        return (Release)this.releasePersistence.update((BaseModel)release);
    }

    public Release addRelease(String servletContextName, String schemaVersion) {
        Release release = null;
        if (servletContextName.equals("portal")) {
            release = this.releasePersistence.create(1L);
        } else {
            long releaseId = this.counterLocalService.increment();
            release = this.releasePersistence.create(releaseId);
        }
        Date date = new Date();
        release.setCreateDate(date);
        release.setModifiedDate(date);
        release.setServletContextName(servletContextName);
        release.setSchemaVersion(schemaVersion);
        if (servletContextName.equals("portal")) {
            release.setTestString(ReleaseConstants.TEST_STRING);
        }
        return (Release)this.releasePersistence.update((BaseModel)release);
    }

    @Deprecated
    public void createTablesAndPopulate() {
    }

    public Release fetchRelease(String servletContextName) {
        if (Validator.isNull((String)servletContextName)) {
            throw new IllegalArgumentException("Servlet context name is null");
        }
        Release release = null;
        release = servletContextName.equals("portal") ? this.releasePersistence.fetchByPrimaryKey(1L) : this.releasePersistence.fetchByServletContextName(servletContextName);
        return release;
    }

    @Deprecated
    @Transactional
    public int getBuildNumberOrCreate() throws PortalException {
        Release release = this.releasePersistence.fetchByPrimaryKey(1L);
        if (release != null) {
            return release.getBuildNumber();
        }
        throw new NoSuchReleaseException("The database needs to be populated");
    }

    public Release updateRelease(long releaseId, String schemaVersion, int buildNumber, Date buildDate, boolean verified) throws PortalException {
        Release release = this.releasePersistence.findByPrimaryKey(releaseId);
        release.setModifiedDate(new Date());
        release.setSchemaVersion(schemaVersion);
        release.setBuildNumber(buildNumber);
        release.setBuildDate(buildDate);
        release.setVerified(verified);
        return (Release)this.releasePersistence.update((BaseModel)release);
    }

    public void updateRelease(String servletContextName, List<UpgradeProcess> upgradeProcesses, int buildNumber, int previousBuildNumber) throws PortalException {
        if (buildNumber <= 0) {
            _log.error((Object)("Skipping upgrade processes for " + servletContextName + " because \"release.info.build.number\" is not specified"));
            return;
        }
        Release release = this.releaseLocalService.fetchRelease(servletContextName);
        if (release == null) {
            release = this.releaseLocalService.addRelease(servletContextName, previousBuildNumber);
        }
        if (buildNumber == release.getBuildNumber()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping upgrade processes for " + servletContextName + " because it is already up to date"));
            }
        } else {
            if (buildNumber < release.getBuildNumber()) {
                throw new OlderVersionException("Skipping upgrade processes for " + servletContextName + " because you are trying to upgrade with an older version");
            }
            UpgradeProcessUtil.upgradeProcess((int)release.getBuildNumber(), upgradeProcesses);
        }
        this.releaseLocalService.updateRelease(release.getReleaseId(), release.getSchemaVersion(), buildNumber, null, true);
    }

    @Deprecated
    public void updateRelease(String servletContextName, List<UpgradeProcess> upgradeProcesses, int buildNumber, int previousBuildNumber, boolean indexOnUpgrade) throws PortalException {
        this.updateRelease(servletContextName, upgradeProcesses, buildNumber, previousBuildNumber);
    }

    public void updateRelease(String servletContextName, List<UpgradeProcess> upgradeProcesses, Properties unfilteredPortalProperties) throws Exception {
        int buildNumber = GetterUtil.getInteger((String)unfilteredPortalProperties.getProperty("release.info.build.number"));
        int previousBuildNumber = GetterUtil.getInteger((String)unfilteredPortalProperties.getProperty("release.info.previous.build.number"), (int)buildNumber);
        this.updateRelease(servletContextName, upgradeProcesses, buildNumber, previousBuildNumber);
    }

    public void updateRelease(String servletContextName, String schemaVersion, String previousSchemaVersion) {
        String currentSchemaVersion;
        Release release = this.releaseLocalService.fetchRelease(servletContextName);
        if (release == null) {
            if (previousSchemaVersion.equals("0.0.0")) {
                release = this.releaseLocalService.addRelease(servletContextName, previousSchemaVersion);
            } else {
                throw new IllegalStateException("Unable to update release because it does not exist");
            }
        }
        if (Validator.isNull((String)(currentSchemaVersion = release.getSchemaVersion()))) {
            currentSchemaVersion = "0.0.0";
        }
        if (!previousSchemaVersion.equals(currentSchemaVersion)) {
            throw new IllegalStateException(StringBundler.concat((String[])new String[]{"Unable to update release because the previous schema ", "version ", previousSchemaVersion, " does not match the expected schema version ", currentSchemaVersion}));
        }
        release.setSchemaVersion(schemaVersion);
        this.releasePersistence.update((BaseModel)release);
    }
}

