/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdHttpSession;
import com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdSplitterUtil;
import com.liferay.portal.servlet.PortalSessionCreator;
import com.liferay.portal.servlet.PortalSessionDestroyer;
import com.liferay.portal.util.PropsValues;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class PortalSessionListener
implements HttpSessionListener {
    private static final Log _log = LogFactoryUtil.getLog(PortalSessionListener.class);
    private final AtomicInteger _counter = new AtomicInteger();

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession = httpSessionEvent.getSession();
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter()) {
            httpSession = new CompoundSessionIdHttpSession(httpSessionEvent.getSession());
        }
        new PortalSessionCreator(httpSession);
        if (PropsValues.SESSION_MAX_ALLOWED > 0 && this._counter.incrementAndGet() > PropsValues.SESSION_MAX_ALLOWED) {
            httpSession.setAttribute("SESSION_MAX_ALLOWED", (Object)Boolean.TRUE);
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Exceeded maximum number of ", PropsValues.SESSION_MAX_ALLOWED, " sessions allowed. You may be experiencing a DoS ", "attack."}));
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession = httpSessionEvent.getSession();
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter()) {
            httpSession = new CompoundSessionIdHttpSession(httpSessionEvent.getSession());
        }
        new PortalSessionDestroyer(httpSession);
        if (PropsValues.SESSION_MAX_ALLOWED > 0) {
            this._counter.decrementAndGet();
        }
    }
}

