/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.servlet.NullSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class SharedSessionWrapper
implements HttpSession {
    private static final Log _log = LogFactoryUtil.getLog(SharedSessionWrapper.class);
    private static final Map<String, String> _sharedSessionAttributesExcludes = new HashMap<String, String>(){
        {
            for (String name : PropsValues.SESSION_SHARED_ATTRIBUTES_EXCLUDES) {
                this.put(name, name);
            }
        }
    };
    private final HttpSession _portalHttpSession;
    private HttpSession _portletHttpSession;

    public SharedSessionWrapper(HttpSession portalHttpSession, HttpSession portletHttpSession) {
        if (portalHttpSession == null) {
            this._portalHttpSession = new NullSession();
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Wrapped portal session is null");
            }
        } else {
            this._portalHttpSession = portalHttpSession;
        }
        this._portletHttpSession = portletHttpSession;
    }

    public Object getAttribute(String name) {
        HttpSession httpSession = this.getSessionDelegate(name);
        return httpSession.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        HttpSession httpSession = this.getSessionDelegate();
        Enumeration namesEnumeration = httpSession.getAttributeNames();
        if (httpSession == this._portletHttpSession) {
            ArrayList namesList = Collections.list(namesEnumeration);
            Enumeration portalHttpSessionNamesEnumeration = this._portalHttpSession.getAttributeNames();
            while (portalHttpSessionNamesEnumeration.hasMoreElements()) {
                String name = (String)portalHttpSessionNamesEnumeration.nextElement();
                if (!this.containsSharedAttribute(name)) continue;
                namesList.add(name);
            }
            namesEnumeration = Collections.enumeration(namesList);
        }
        return namesEnumeration;
    }

    public long getCreationTime() {
        HttpSession httpSession = this.getSessionDelegate();
        return httpSession.getCreationTime();
    }

    public String getId() {
        HttpSession httpSession = this.getSessionDelegate();
        return httpSession.getId();
    }

    public long getLastAccessedTime() {
        HttpSession httpSession = this.getSessionDelegate();
        return httpSession.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        HttpSession httpSession = this.getSessionDelegate();
        return httpSession.getMaxInactiveInterval();
    }

    public ServletContext getServletContext() {
        HttpSession httpSession = this.getSessionDelegate();
        return httpSession.getServletContext();
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        HttpSession httpSession = this.getSessionDelegate();
        return httpSession.getSessionContext();
    }

    @Deprecated
    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    @Deprecated
    public String[] getValueNames() {
        List names = ListUtil.fromEnumeration(this.getAttributeNames());
        return names.toArray(new String[0]);
    }

    public void invalidate() {
        HttpSession httpSession = this.getSessionDelegate();
        httpSession.invalidate();
    }

    public boolean isNew() {
        HttpSession httpSession = this.getSessionDelegate();
        return httpSession.isNew();
    }

    @Deprecated
    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        HttpSession httpSession = this.getSessionDelegate(name);
        httpSession.removeAttribute(name);
    }

    @Deprecated
    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        HttpSession httpSession = this.getSessionDelegate(name);
        httpSession.setAttribute(name, value);
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        HttpSession httpSession = this.getSessionDelegate();
        httpSession.setMaxInactiveInterval(maxInactiveInterval);
    }

    protected boolean containsSharedAttribute(String name) {
        for (String sharedName : PropsValues.SESSION_SHARED_ATTRIBUTES) {
            if (!name.startsWith(sharedName)) continue;
            return true;
        }
        return false;
    }

    protected HttpSession getSessionDelegate() {
        if (this._portletHttpSession != null) {
            return this._portletHttpSession;
        }
        return this._portalHttpSession;
    }

    protected HttpSession getSessionDelegate(String name) {
        if (this._portletHttpSession == null) {
            return this._portalHttpSession;
        }
        if (_sharedSessionAttributesExcludes.containsKey(name)) {
            return this._portletHttpSession;
        }
        if (this.containsSharedAttribute(name)) {
            return this._portalHttpSession;
        }
        return this._portletHttpSession;
    }
}

