/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.lockout;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManagerUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LockoutFilter
extends BasePortalFilter {
    private static final Log _log = LogFactoryUtil.getLog(LockoutFilter.class);

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        if (this._isLockout(httpServletRequest)) {
            AuthenticatedSessionManagerUtil.logout((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            if (StringUtil.equals((String)httpServletRequest.getMethod(), (String)"GET")) {
                httpServletResponse.sendRedirect(PortalUtil.getCurrentCompleteURL((HttpServletRequest)httpServletRequest));
            } else {
                httpServletResponse.sendRedirect(PortalUtil.getPortalURL((HttpServletRequest)httpServletRequest));
            }
        } else {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    private boolean _isLockout(HttpServletRequest httpServletRequest) {
        try {
            User user = PortalUtil.getUser((HttpServletRequest)httpServletRequest);
            return user != null && user.isLockout();
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
            return false;
        }
    }
}

