/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sharepoint;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.sharepoint.SharepointException;
import com.liferay.portal.sharepoint.SharepointRequest;
import com.liferay.portal.sharepoint.SharepointUtil;
import com.liferay.portal.sharepoint.methods.Method;
import com.liferay.portal.sharepoint.methods.MethodFactory;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SharepointServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(SharepointServlet.class);

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{httpServletRequest.getHeader("User-Agent"), " ", httpServletRequest.getMethod(), " ", httpServletRequest.getRequestURI()}));
        }
        try {
            String uri = httpServletRequest.getRequestURI();
            if (uri.equals("/_vti_inf.html")) {
                this.vtiInfHtml(httpServletResponse);
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            String uri = httpServletRequest.getRequestURI();
            if (uri.equals("/_vti_bin/shtml.dll/_vti_rpc") || uri.equals("/sharepoint/_vti_bin/_vti_aut/author.dll")) {
                HttpSession httpSession = httpServletRequest.getSession();
                User user = (User)httpSession.getAttribute("USER");
                SharepointRequest sharepointRequest = new SharepointRequest(httpServletRequest, httpServletResponse, user);
                Method method = MethodFactory.create(sharepointRequest);
                String rootPath = method.getRootPath(sharepointRequest);
                if (rootPath == null) {
                    throw new SharepointException("Unabled to get root path");
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Original root path " + rootPath));
                }
                rootPath = WebDAVUtil.stripManualCheckInRequiredPath((String)rootPath);
                rootPath = WebDAVUtil.stripOfficeExtension((String)rootPath);
                rootPath = SharepointUtil.stripService(rootPath, true);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Modified root path " + rootPath));
                }
                sharepointRequest.setRootPath(rootPath);
                sharepointRequest.setSharepointStorage(SharepointUtil.getStorage(rootPath));
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((String[])new String[]{httpServletRequest.getHeader("User-Agent"), " ", method.getMethodName(), " ", uri, " ", rootPath}));
                }
                method.process(sharepointRequest);
            } else if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{httpServletRequest.getHeader("User-Agent"), " ", httpServletRequest.getMethod(), " ", uri}));
            }
        }
        catch (SharepointException sharepointException) {
            _log.error((Object)sharepointException, (Throwable)((Object)sharepointException));
        }
    }

    protected void vtiInfHtml(HttpServletResponse httpServletResponse) throws Exception {
        ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)StringBundler.concat((String[])new String[]{"<!-- FrontPage Configuration Information", "\n", " FPVersion=\"6.0.2.9999\"", "\n", "FPShtmlScriptUrl=\"_vti_bin/shtml.dll/_vti_rpc\"", "\n", "FPAuthorScriptUrl=\"_vti_bin/_vti_aut/author.dll\"", "\n", "FPAdminScriptUrl=\"_vti_bin/_vti_adm/admin.dll\"", "\n", "TPScriptUrl=\"_vti_bin/owssvr.dll\"", "\n", "-->"}));
    }
}

