/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.DirectRequestDispatcherFactoryUtil;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StrutsUtil {
    public static final String EXCEPTION = StrutsUtil.class.getName() + "_EXCEPTION";
    public static final String TEXT_HTML_DIR = "/html";
    private static final Log _log = LogFactoryUtil.getLog(StrutsUtil.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void forward(String uri, ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Forward URI " + uri));
        }
        if (uri.equals("/common/null.jsp")) {
            return;
        }
        if (!httpServletResponse.isCommitted()) {
            String path = TEXT_HTML_DIR.concat(uri);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Forward path " + path));
            }
            RequestDispatcher requestDispatcher = DirectRequestDispatcherFactoryUtil.getRequestDispatcher((ServletContext)servletContext, (String)path);
            try {
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) return;
                _log.warn((Object)ioException, (Throwable)ioException);
                return;
            }
            catch (ServletException servletException1) {
                httpServletRequest.setAttribute(EXCEPTION, (Object)servletException1.getRootCause());
                String errorPath = "/html/common/error.jsp";
                requestDispatcher = DirectRequestDispatcherFactoryUtil.getRequestDispatcher((ServletContext)servletContext, (String)errorPath);
                try {
                    requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    return;
                }
                catch (IOException ioException) {
                    if (!_log.isWarnEnabled()) return;
                    _log.warn((Object)ioException, (Throwable)ioException);
                    return;
                }
                catch (ServletException servletException2) {
                    throw servletException2;
                }
            }
        } else {
            if (!_log.isWarnEnabled()) return;
            _log.warn((Object)(uri + " is already committed"));
        }
    }
}

