/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.WorkflowInstanceLink;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;

public class UpgradeSubscription
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeSubscription.class);
    private static final Map<String, String> _getGroupIdSQLPartsMap = HashMapBuilder.put((Object)DLFileEntry.class.getName(), (Object)"DLFileEntry,groupId,fileEntryId").put((Object)DLFileEntryType.class.getName(), (Object)"DLFileEntryType,groupId,fileEntryTypeId").put((Object)DLFolder.class.getName(), (Object)"DLFolder,groupId,folderId").put((Object)Layout.class.getName(), (Object)"Layout,groupId,plid").put((Object)"com.liferay.calendar.model.CalendarBooking", (Object)"CalendarBooking,groupId,calendarBookingId").put((Object)"com.liferay.knowledgebase.model.KBArticle", (Object)"KBArticle,groupId,kbArticleId").put((Object)"com.liferay.message.boards.kernel.model.MBCategory", (Object)"MBCategory,groupId,categoryId").put((Object)"com.liferay.message.boards.kernel.model.MBThread", (Object)"MBThread,groupId,threadId").put((Object)WorkflowInstanceLink.class.getName(), (Object)"WorkflowInstanceLink,groupId,workflowInstanceId").put((Object)"com.liferay.blogs.kernel.model.BlogsEntry", (Object)"BlogsEntry,groupId,entryId").put((Object)"com.liferay.journal.model.JournalArticle", (Object)"JournalArticle,groupId,resourcePrimKey").put((Object)"com.liferay.journal.model.JournalFolder", (Object)"JournalFolder,groupId,folderId").put((Object)"com.liferay.portal.kernel.model.PortletPreferences", (Object)"PortletPreferences,plid,portletPreferencesId").put((Object)"com.liferay.portlet.bookmarks.model.BookmarksEntry", (Object)"BookmarksEntry,groupId,entryId").put((Object)"com.liferay.portlet.bookmarks.model.BookmarksFolder", (Object)"BookmarksFolder,groupId,folderId").put((Object)"com.liferay.portlet.dynamic.data.mapping.kernel.DDMStructure", (Object)"DDMStructure,groupId,structureId").put((Object)"com.liferay.portlet.wiki.model.WikiNode", (Object)"WikiNode,groupId,nodeId").put((Object)"com.liferay.portlet.wiki.model.WikiPage", (Object)"WikiPage,groupId,resourcePrimKey").build();

    protected void addClassName(long classNameId, String className) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("insert into ClassName_ (mvccVersion, classNameId, value) values (?, ?, ?)");){
            preparedStatement.setLong(1, 0L);
            preparedStatement.setLong(2, classNameId);
            preparedStatement.setString(3, className);
            preparedStatement.executeUpdate();
        }
    }

    protected void deleteOrphanedSubscriptions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long classNameId = PortalUtil.getClassNameId((String)PortletPreferences.class.getName());
            this.runSQL(StringBundler.concat((Object[])new Object[]{"delete from Subscription where classNameId = ", classNameId, " and classPK not in (select portletPreferencesId from ", "PortletPreferences)"}));
        }
    }

    protected void doUpgrade() throws Exception {
        this.deleteOrphanedSubscriptions();
        this.updateSubscriptionClassNames(Folder.class.getName(), DLFolder.class.getName());
        this.updateSubscriptionGroupIds();
    }

    protected long getClassNameId(String className) throws Exception {
        long classNameId = PortalUtil.getClassNameId((String)className);
        if (classNameId != 0L) {
            return classNameId;
        }
        classNameId = this.increment();
        this.addClassName(classNameId, className);
        return classNameId;
    }

    protected long getGroupId(long classNameId, long classPK) throws Exception {
        block68: {
            String className = PortalUtil.getClassName((long)classNameId);
            Object[] groupIdSQLParts = StringUtil.split((String)_getGroupIdSQLPartsMap.get(className));
            if (ArrayUtil.isEmpty((Object[])groupIdSQLParts)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to determine the group ID for the class name " + className));
                }
                return 0L;
            }
            Object tableName = groupIdSQLParts[0];
            String sql = StringBundler.concat((String[])new String[]{"select ", groupIdSQLParts[1], " from ", tableName, " where ", groupIdSQLParts[2], " = ?"});
            try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(sql);){
                long l;
                preparedStatement1.setLong(1, classPK);
                try (ResultSet resultSet1 = preparedStatement1.executeQuery();){
                    if (!resultSet1.next()) break block68;
                    if (((String)tableName).equals("PortletPreferences")) {
                        long plid = resultSet1.getLong("plid");
                        try (PreparedStatement preparedStatement2 = this.connection.prepareStatement("select groupId from Layout where plid = ?");){
                            preparedStatement2.setLong(1, plid);
                            try (ResultSet resultSet2 = preparedStatement2.executeQuery();){
                                if (resultSet2.next()) {
                                    long l2 = resultSet2.getLong("groupId");
                                    return l2;
                                }
                                break block68;
                            }
                        }
                    }
                    l = resultSet1.getLong("groupId");
                }
                return l;
            }
        }
        return 0L;
    }

    protected boolean hasGroup(long groupId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select count(*) from Group_ where groupId = ?");){
            preparedStatement.setLong(1, groupId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                int count;
                if (resultSet.next() && (count = resultSet.getInt(1)) > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    protected void updateSubscriptionClassNames(String oldClassName, String newClassName) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(oldClassName);){
            this.runSQL(StringBundler.concat((Object[])new Object[]{"update Subscription set classNameId = ", this.getClassNameId(newClassName), " where classNameId = ", PortalUtil.getClassNameId((String)oldClassName)}));
        }
    }

    protected void updateSubscriptionGroupIds() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select subscriptionId, classNameId, classPK from Subscription");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update Subscription set groupId = ? where subscriptionId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long classPK;
                long classNameId = resultSet.getLong("classNameId");
                long groupId = this.getGroupId(classNameId, classPK = resultSet.getLong("classPK"));
                if (groupId == 0L && this.hasGroup(classPK)) {
                    groupId = classPK;
                }
                if (groupId == 0L) continue;
                preparedStatement2.setLong(1, groupId);
                long subscriptionId = resultSet.getLong("subscriptionId");
                preparedStatement2.setLong(2, subscriptionId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

