/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class JarUtil {
    private static final Log _log = LogFactoryUtil.getLog(JarUtil.class);
    private static final Method _addURLMethod;

    public static void downloadAndInstallJar(URL url, Path path) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Downloading ", url, " to ", path}));
        }
        try (InputStream inputStream = url.openStream();){
            Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Downloaded ", url, " to ", path}));
        }
    }

    public static void downloadAndInstallJar(URL url, Path path, URLClassLoader urlClassLoader) throws Exception {
        JarUtil.downloadAndInstallJar(url, path);
        URI uri = path.toUri();
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Installing ", path, " to ", urlClassLoader}));
        }
        _addURLMethod.invoke((Object)urlClassLoader, uri.toURL());
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Installed ", path, " to ", urlClassLoader}));
        }
    }

    @Deprecated
    public static Path downloadAndInstallJar(URL url, String libPath, String name) throws Exception {
        File file = new File(libPath, name);
        Path path = file.toPath();
        JarUtil.downloadAndInstallJar(url, path);
        return path;
    }

    @Deprecated
    public static void downloadAndInstallJar(URL url, String libPath, String name, URLClassLoader urlClassLoader) throws Exception {
        File file = new File(libPath, name);
        Path path = file.toPath();
        JarUtil.downloadAndInstallJar(url, path, urlClassLoader);
    }

    static {
        try {
            _addURLMethod = ReflectionUtil.getDeclaredMethod(URLClassLoader.class, (String)"addURL", (Class[])new Class[]{URL.class});
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

