/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webcache;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.webcache.WebCacheException;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.webcache.WebCachePool;
import java.io.Serializable;

public class WebCachePoolImpl
implements WebCachePool {
    private static final String _CACHE_NAME = WebCachePool.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(WebCachePoolImpl.class);
    private PortalCache<String, Object> _portalCache;

    public void afterPropertiesSet() {
        this._portalCache = PortalCacheHelperUtil.getPortalCache((String)"SINGLE_VM_PORTAL_CACHE_MANAGER", (String)_CACHE_NAME);
    }

    public void clear() {
        this._portalCache.removeAll();
    }

    public Object get(String key, WebCacheItem webCacheItem) {
        Object object;
        block6: {
            object = this._portalCache.get((Serializable)((Object)key));
            if (object != null) {
                return object;
            }
            try {
                object = webCacheItem.convert(key);
                if (object == null) {
                    return null;
                }
                int timeToLive = (int)(webCacheItem.getRefreshTime() / 1000L);
                if (timeToLive > 0) {
                    this._portalCache.put((Serializable)((Object)key), object, timeToLive);
                }
            }
            catch (WebCacheException webCacheException) {
                if (!_log.isWarnEnabled()) break block6;
                Throwable throwable = webCacheException.getCause();
                if (throwable != null) {
                    _log.warn((Object)throwable, throwable);
                }
                _log.warn((Object)webCacheException, (Throwable)webCacheException);
            }
        }
        return object;
    }

    public void remove(String key) {
        this._portalCache.remove((Serializable)((Object)key));
    }
}

