/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypeAccessPolicy;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.ActionResult;
import com.liferay.portal.kernel.portlet.PortletContainer;
import com.liferay.portal.kernel.portlet.PortletContainerException;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenWhitelistUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.TempAttributesServletRequest;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.util.LayoutTypeAccessPolicyTracker;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import java.util.Map;
import javax.portlet.Event;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SecurityPortletContainerWrapper
implements PortletContainer {
    private static final Log _log = LogFactoryUtil.getLog(SecurityPortletContainerWrapper.class);
    private final PortletContainer _portletContainer;

    @Deprecated
    public static PortletContainer createSecurityPortletContainerWrapper(PortletContainer portletContainer) {
        return new SecurityPortletContainerWrapper(portletContainer);
    }

    public SecurityPortletContainerWrapper(PortletContainer portletContainer) {
        this._portletContainer = portletContainer;
    }

    public void preparePortlet(HttpServletRequest httpServletRequest, Portlet portlet) throws PortletContainerException {
        this._portletContainer.preparePortlet(httpServletRequest, portlet);
    }

    public ActionResult processAction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        try {
            HttpServletRequest ownerLayoutHttpServletRequest = this.getOwnerLayoutRequestWrapper(httpServletRequest, portlet);
            this.checkAction(ownerLayoutHttpServletRequest, portlet);
            return this._portletContainer.processAction(httpServletRequest, httpServletResponse, portlet);
        }
        catch (PrincipalException principalException) {
            return this.processActionException(httpServletRequest, httpServletResponse, portlet, principalException);
        }
        catch (PortletContainerException portletContainerException) {
            throw portletContainerException;
        }
        catch (Exception exception) {
            throw new PortletContainerException((Throwable)exception);
        }
    }

    public List<Event> processEvent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet, Layout layout, Event event) throws PortletContainerException {
        return this._portletContainer.processEvent(httpServletRequest, httpServletResponse, portlet, layout, event);
    }

    public void processPublicRenderParameters(HttpServletRequest httpServletRequest, Layout layout) {
        this._portletContainer.processPublicRenderParameters(httpServletRequest, layout);
    }

    public void processPublicRenderParameters(HttpServletRequest httpServletRequest, Layout layout, Portlet portlet) {
        this._portletContainer.processPublicRenderParameters(httpServletRequest, layout, portlet);
    }

    public void render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        try {
            this.checkRender(httpServletRequest, portlet);
            this._portletContainer.render(httpServletRequest, httpServletResponse, portlet);
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)principalException, (Throwable)principalException);
            }
            this.processRenderException(httpServletRequest, httpServletResponse, portlet);
        }
        catch (PortletContainerException portletContainerException) {
            throw portletContainerException;
        }
        catch (Exception exception) {
            throw new PortletContainerException((Throwable)exception);
        }
    }

    public void renderHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        try {
            this.checkRender(httpServletRequest, portlet);
            this._portletContainer.renderHeaders(httpServletRequest, httpServletResponse, portlet);
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)principalException, (Throwable)principalException);
            }
            this.processRenderException(httpServletRequest, httpServletResponse, portlet);
        }
        catch (PortletContainerException portletContainerException) {
            throw portletContainerException;
        }
        catch (Exception exception) {
            throw new PortletContainerException((Throwable)exception);
        }
    }

    public void serveResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        try {
            HttpServletRequest ownerLayoutHttpServletRequest = this.getOwnerLayoutRequestWrapper(httpServletRequest, portlet);
            this.checkResource(ownerLayoutHttpServletRequest, portlet);
            this._portletContainer.serveResource(httpServletRequest, httpServletResponse, portlet);
        }
        catch (PrincipalException principalException) {
            this.processServeResourceException(httpServletRequest, httpServletResponse, portlet, principalException);
        }
        catch (PortletContainerException portletContainerException) {
            throw portletContainerException;
        }
        catch (Exception exception) {
            throw new PortletContainerException((Throwable)exception);
        }
    }

    protected void check(HttpServletRequest httpServletRequest, Portlet portlet) throws Exception {
        if (portlet == null) {
            return;
        }
        if (!this.isValidPortletId(portlet.getPortletId())) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Invalid portlet ID " + portlet.getPortletId()));
            }
            throw new PrincipalException("Invalid portlet ID " + portlet.getPortletId());
        }
        if (portlet.isUndeployedPortlet()) {
            return;
        }
        Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        LayoutTypeAccessPolicy layoutTypeAccessPolicy = LayoutTypeAccessPolicyTracker.getLayoutTypeAccessPolicy(layout);
        layoutTypeAccessPolicy.checkAccessAllowedToPortlet(httpServletRequest, layout, portlet);
    }

    protected void checkAction(HttpServletRequest httpServletRequest, Portlet portlet) throws Exception {
        this.checkCSRFProtection(httpServletRequest, portlet);
        this.check(httpServletRequest, portlet);
    }

    protected void checkCSRFProtection(HttpServletRequest httpServletRequest, Portlet portlet) throws PortalException {
        Map initParams = portlet.getInitParams();
        boolean checkAuthToken = GetterUtil.getBoolean((String)((String)initParams.get("check-auth-token")), (boolean)true);
        if (AuthTokenWhitelistUtil.isPortletCSRFWhitelisted((HttpServletRequest)httpServletRequest, (Portlet)portlet)) {
            checkAuthToken = false;
        }
        if (checkAuthToken) {
            AuthTokenUtil.checkCSRFToken((HttpServletRequest)httpServletRequest, (String)SecurityPortletContainerWrapper.class.getName());
        }
    }

    protected void checkRender(HttpServletRequest httpServletRequest, Portlet portlet) throws Exception {
        this.check(httpServletRequest, portlet);
    }

    protected void checkResource(HttpServletRequest httpServletRequest, Portlet portlet) throws Exception {
        this.check(httpServletRequest, portlet);
    }

    protected String getOriginalURL(HttpServletRequest httpServletRequest) {
        LastPath lastPath = (LastPath)httpServletRequest.getAttribute("LAST_PATH");
        if (lastPath == null) {
            return String.valueOf(httpServletRequest.getRequestURI());
        }
        return StringBundler.concat((String[])new String[]{PortalUtil.getPortalURL((HttpServletRequest)httpServletRequest), lastPath.getContextPath(), lastPath.getPath()});
    }

    protected HttpServletRequest getOwnerLayoutRequestWrapper(HttpServletRequest httpServletRequest, Portlet portlet) throws Exception {
        if (!PropsValues.PORTLET_EVENT_DISTRIBUTION_LAYOUT_SET || PropsValues.PORTLET_CROSS_LAYOUT_INVOCATION_MODE.equals("render")) {
            return httpServletRequest;
        }
        Layout ownerLayout = null;
        LayoutTypePortlet ownerLayoutTypePortlet = null;
        Layout requestLayout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        List layoutTypePortlets = PortletContainerUtil.getLayoutTypePortlets((Layout)requestLayout);
        for (LayoutTypePortlet layoutTypePortlet : layoutTypePortlets) {
            if (!layoutTypePortlet.hasPortletId(portlet.getPortletId())) continue;
            ownerLayoutTypePortlet = layoutTypePortlet;
            ownerLayout = layoutTypePortlet.getLayout();
            break;
        }
        if (ownerLayout == null) {
            return httpServletRequest;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout currentLayout = themeDisplay.getLayout();
        if (currentLayout.equals(ownerLayout)) {
            return httpServletRequest;
        }
        ThemeDisplay themeDisplayClone = (ThemeDisplay)themeDisplay.clone();
        themeDisplayClone.setLayout(ownerLayout);
        themeDisplayClone.setLayoutTypePortlet(ownerLayoutTypePortlet);
        TempAttributesServletRequest tempAttributesServletRequest = new TempAttributesServletRequest(httpServletRequest);
        tempAttributesServletRequest.setTempAttribute("LAYOUT", (Object)ownerLayout);
        tempAttributesServletRequest.setTempAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplayClone);
        return tempAttributesServletRequest;
    }

    protected boolean isValidPortletId(String portletId) {
        for (int i = 0; i < portletId.length(); ++i) {
            char c = portletId.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '$' || c == '#' || c == '_') continue;
            return false;
        }
        return true;
    }

    protected ActionResult processActionException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet, PrincipalException principalException) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)principalException, (Throwable)principalException);
        }
        if (_log.isWarnEnabled() && !(principalException instanceof PrincipalException.MustHaveSessionCSRFToken)) {
            String url = this.getOriginalURL(httpServletRequest);
            _log.warn((Object)String.format("User %s is not allowed to access URL %s and portlet %s: %s", PortalUtil.getUserId((HttpServletRequest)httpServletRequest), url, portlet.getPortletId(), principalException.getMessage()));
        }
        httpServletResponse.setStatus(403);
        return ActionResult.EMPTY_ACTION_RESULT;
    }

    protected void processRenderException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        String portletContent = null;
        if (portlet.isShowPortletAccessDenied()) {
            portletContent = "/html/portal/portlet_access_denied.jsp";
        }
        try {
            if (portletContent != null) {
                HttpServletRequest originalHttpServletRequest = PortalUtil.getOriginalServletRequest((HttpServletRequest)httpServletRequest);
                RequestDispatcher requestDispatcher = originalHttpServletRequest.getRequestDispatcher(portletContent);
                requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        }
        catch (Exception exception) {
            throw new PortletContainerException((Throwable)exception);
        }
    }

    protected void processServeResourceException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet, PrincipalException principalException) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)principalException, (Throwable)principalException);
        }
        httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
        httpServletResponse.setStatus(403);
        if (principalException instanceof PrincipalException.MustHaveSessionCSRFToken) {
            return;
        }
        if (_log.isWarnEnabled()) {
            String url = this.getOriginalURL(httpServletRequest);
            _log.warn((Object)String.format("User %s is not allowed to serve resource for %s on %s: %s", PortalUtil.getUserId((HttpServletRequest)httpServletRequest), url, portlet.getPortletId(), principalException.getMessage()));
        }
    }
}

