/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.change.tracking.store.CTStoreFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Collections;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class StoreFactory {
    private static final Log _log = LogFactoryUtil.getLog(StoreFactory.class);
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static volatile Store _defaultStore;
    private static StoreFactory _storeFactory;
    private static final StoreServiceTrackerMapHolder _storeServiceTrackerMapHolder;
    private static boolean _warned;

    public static StoreFactory getInstance() {
        if (_storeFactory == null) {
            _storeFactory = new StoreFactory();
        }
        return _storeFactory;
    }

    public void checkProperties() {
        if (_warned) {
            return;
        }
        String dlHookImpl = PropsUtil.get("dl.hook.impl");
        if (Validator.isNull((String)dlHookImpl)) {
            _warned = true;
            return;
        }
        boolean found = false;
        for (String key : _storeServiceTrackerMapHolder.keySet()) {
            Store store = this.getStore(key);
            Class<?> clazz = store.getClass();
            String className = clazz.getName();
            if (!dlHookImpl.equals(className)) continue;
            PropsValues.DL_STORE_IMPL = className;
            found = true;
            break;
        }
        if (!found) {
            PropsValues.DL_STORE_IMPL = dlHookImpl;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Liferay is configured with the legacy property ", "\"dl.hook.impl=", dlHookImpl, "\" in portal-ext.properties. Please reconfigure to use ", "the new property \"", "dl.store.impl", "\". Liferay will attempt to temporarily set \"", "dl.store.impl", "=", PropsValues.DL_STORE_IMPL, "\"."}));
        }
        _warned = true;
    }

    public Store getStore() {
        Store store = _defaultStore;
        if (store == null) {
            throw new IllegalStateException("Store is not available. Caller service needs to wait for store factory with \"dl.store.impl.enabled=true\".");
        }
        return store;
    }

    public Store getStore(String key) {
        return _storeServiceTrackerMapHolder.getService(key);
    }

    public String[] getStoreTypes() {
        Set<String> storeTypes = _storeServiceTrackerMapHolder.keySet();
        return storeTypes.toArray(new String[0]);
    }

    @Deprecated
    public void setStore(String key) {
    }

    static {
        _storeServiceTrackerMapHolder = new StoreServiceTrackerMapHolder();
    }

    private static class StoreTypeServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Store, Store> {
        private final CTStoreFactory _ctStoreFactory;
        private ServiceRegistration<StoreFactory> _serviceRegistration;

        public StoreTypeServiceTrackerCustomizer(CTStoreFactory ctStoreFactory) {
            this._ctStoreFactory = ctStoreFactory;
        }

        public Store addingService(ServiceReference<Store> serviceReference) {
            String storeType = GetterUtil.getString((Object)serviceReference.getProperty("store.type"));
            final Store store = this._getStore(serviceReference, storeType);
            if (StringUtil.equals((String)storeType, (String)PropsValues.DL_STORE_IMPL)) {
                _defaultStore = store;
                this._serviceRegistration = _bundleContext.registerService(StoreFactory.class, (Object)new StoreFactory(){

                    @Override
                    public Store getStore() {
                        return store;
                    }
                }, MapUtil.singletonDictionary((Object)"dl.store.impl.enabled", (Object)"true"));
            }
            return store;
        }

        public void modifiedService(ServiceReference<Store> serviceReference, Store service) {
        }

        public void removedService(ServiceReference<Store> serviceReference, Store service) {
            String storeType = GetterUtil.getString((Object)serviceReference.getProperty("store.type"));
            if (StringUtil.equals((String)storeType, (String)PropsValues.DL_STORE_IMPL)) {
                this._serviceRegistration.unregister();
            }
            _bundleContext.ungetService(serviceReference);
        }

        private Store _getStore(ServiceReference<Store> serviceReference, String storeType) {
            Store store = (Store)_bundleContext.getService(serviceReference);
            if (!GetterUtil.getBoolean((Object)serviceReference.getProperty("ct.aware"))) {
                store = this._ctStoreFactory.createCTStore(store, storeType);
            }
            return store;
        }
    }

    private static class StoreServiceTrackerMapHolder {
        private final ServiceTracker<CTStoreFactory, ServiceTrackerMap<String, Store>> _serviceTracker = new ServiceTracker(StoreFactory.access$000(), CTStoreFactory.class, (ServiceTrackerCustomizer)new CTStoreFactoryServiceTrackerCustomizer());

        public StoreServiceTrackerMapHolder() {
            this._serviceTracker.open();
        }

        public Store getService(String key) {
            ServiceTrackerMap serviceTrackerMap = (ServiceTrackerMap)this._serviceTracker.getService();
            if (serviceTrackerMap == null) {
                return null;
            }
            return (Store)serviceTrackerMap.getService((Object)key);
        }

        public Set<String> keySet() {
            ServiceTrackerMap serviceTrackerMap = (ServiceTrackerMap)this._serviceTracker.getService();
            if (serviceTrackerMap == null) {
                return Collections.emptySet();
            }
            return serviceTrackerMap.keySet();
        }
    }

    private static class CTStoreFactoryServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<CTStoreFactory, ServiceTrackerMap<String, Store>> {
        private CTStoreFactoryServiceTrackerCustomizer() {
        }

        public ServiceTrackerMap<String, Store> addingService(ServiceReference<CTStoreFactory> serviceReference) {
            CTStoreFactory ctStoreFactory = (CTStoreFactory)_bundleContext.getService(serviceReference);
            return ServiceTrackerMapFactory.openSingleValueMap((BundleContext)_bundleContext, Store.class, (String)"store.type", (ServiceTrackerCustomizer)new StoreTypeServiceTrackerCustomizer(ctStoreFactory));
        }

        public void modifiedService(ServiceReference<CTStoreFactory> serviceReference, ServiceTrackerMap<String, Store> serviceTrackerMap) {
        }

        public void removedService(ServiceReference<CTStoreFactory> serviceReference, ServiceTrackerMap<String, Store> serviceTrackerMap) {
            serviceTrackerMap.close();
            _bundleContext.ungetService(serviceReference);
        }
    }
}

