/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portlet.documentlibrary.util.JQTFastStart;
import com.liferay.portlet.documentlibrary.util.LiferayConverter;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.Configuration;
import com.xuggle.xuggler.IAudioResampler;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IConfigurable;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import java.io.File;
import java.util.Properties;

@Deprecated
public class LiferayVideoConverter
extends LiferayConverter {
    private static final double _RATIO_THRESHOLD = 0.3333333333333333;
    private static final int _VIDEO_BIT_RATE_DEFAULT = 250000;
    private static final int _VIDEO_BIT_RATE_MAX = 1200000;
    private static final Log _log = LogFactoryUtil.getLog(LiferayVideoConverter.class);
    private final Properties _ffpresetProperties;
    private int _height;
    private IContainer _inputIContainer;
    private final String _inputURL;
    private IContainer _outputIContainer;
    private final String _outputURL;
    private int _videoBitRate;
    private final String _videoContainer;
    private IRational _videoFrameRate;
    private int _width;

    public LiferayVideoConverter(String inputURL, String outputURL, String videoContainer, Properties videoProperties, Properties ffpresetProperties) {
        this._inputURL = inputURL;
        this._outputURL = outputURL;
        this._videoContainer = videoContainer;
        this._ffpresetProperties = ffpresetProperties;
        this._height = GetterUtil.getInteger((String)videoProperties.getProperty("dl.file.entry.preview.video.height"), (int)this._height);
        this._width = GetterUtil.getInteger((String)videoProperties.getProperty("dl.file.entry.preview.video.width"), (int)this._width);
        this.initVideoBitRate(videoProperties);
        this.initVideoFrameRate(videoProperties);
    }

    @Override
    public void convert() throws Exception {
        try {
            this.doConvert();
        }
        finally {
            if (this._inputIContainer != null && this._inputIContainer.isOpened()) {
                this._inputIContainer.close();
            }
            if (this._outputIContainer != null && this._outputIContainer.isOpened()) {
                this._outputIContainer.close();
            }
        }
        this.createMP4FastStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createMP4FastStart() {
        File videoFile = new File(this._outputURL);
        if (!this._videoContainer.equals("mp4") || !videoFile.exists()) {
            return;
        }
        File tempFile = new File(this._outputURL + ".tmp");
        try {
            JQTFastStart.convert(videoFile, tempFile);
            if (tempFile.exists() && tempFile.length() > 0L) {
                videoFile.delete();
                tempFile.renameTo(videoFile);
            }
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to move MOOV atom to front of MP4 file", (Throwable)exception);
            }
        }
        finally {
            tempFile.delete();
        }
    }

    protected void doConvert() throws Exception {
        this._inputIContainer = IContainer.make();
        this._outputIContainer = IContainer.make();
        this.openContainer(this._inputIContainer, this._inputURL, false);
        this.openContainer(this._outputIContainer, this._outputURL, true);
        int inputStreamsCount = this._inputIContainer.getNumStreams();
        if (inputStreamsCount < 0) {
            throw new RuntimeException("Input URL does not have any streams");
        }
        IAudioResampler[] iAudioResamplers = new IAudioResampler[inputStreamsCount];
        IVideoResampler[] iVideoResamplers = new IVideoResampler[inputStreamsCount];
        IAudioSamples[] inputIAudioSamples = new IAudioSamples[inputStreamsCount];
        IAudioSamples[] outputIAudioSamples = new IAudioSamples[inputStreamsCount];
        IVideoPicture[] inputIVideoPictures = new IVideoPicture[inputStreamsCount];
        IVideoPicture[] outputIVideoPictures = new IVideoPicture[inputStreamsCount];
        IStream[] outputIStreams = new IStream[inputStreamsCount];
        IStreamCoder[] inputIStreamCoders = new IStreamCoder[inputStreamsCount];
        IStreamCoder[] outputIStreamCoders = new IStreamCoder[inputStreamsCount];
        for (int i = 0; i < inputStreamsCount; ++i) {
            IStreamCoder inputIStreamCoder;
            IStream inputIStream = this._inputIContainer.getStream((long)i);
            inputIStreamCoders[i] = inputIStreamCoder = inputIStream.getStreamCoder();
            ICodec.Type inputICodecType = inputIStreamCoder.getCodecType();
            if (inputICodecType == ICodec.Type.CODEC_TYPE_AUDIO) {
                this.prepareAudio(iAudioResamplers, inputIAudioSamples, outputIAudioSamples, inputIStreamCoder, outputIStreamCoders, this._outputIContainer, outputIStreams, inputICodecType, this._outputURL, i);
            } else if (inputICodecType == ICodec.Type.CODEC_TYPE_VIDEO) {
                this.prepareVideo(iVideoResamplers, inputIVideoPictures, outputIVideoPictures, inputIStreamCoder, outputIStreamCoders, this._outputIContainer, outputIStreams, inputICodecType, this._outputURL, i);
            }
            this.openStreamCoder(inputIStreamCoders[i]);
            this.openStreamCoder(outputIStreamCoders[i]);
        }
        if (this._outputIContainer.writeHeader() < 0) {
            throw new RuntimeException("Unable to write container header");
        }
        boolean keyPacketFound = false;
        int nonkeyAfterKeyCount = 0;
        boolean onlyDecodeKeyPackets = false;
        int previousPacketSize = -1;
        IPacket inputIPacket = IPacket.make();
        IPacket outputIPacket = IPacket.make();
        while (this._inputIContainer.readNextPacket(inputIPacket) == 0) {
            int streamIndex;
            IStreamCoder outputIStreamCoder;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Current packet size " + inputIPacket.getSize()));
            }
            if ((outputIStreamCoder = outputIStreamCoders[streamIndex = inputIPacket.getStreamIndex()]) == null) continue;
            IStream iStream = this._inputIContainer.getStream((long)streamIndex);
            long timeStampOffset = this.getStreamTimeStampOffset(iStream);
            IStreamCoder inputIStreamCoder = inputIStreamCoders[streamIndex];
            if (inputIStreamCoder.getCodecType() == ICodec.Type.CODEC_TYPE_AUDIO) {
                this.decodeAudio(iAudioResamplers[streamIndex], inputIAudioSamples[streamIndex], outputIAudioSamples[streamIndex], inputIPacket, outputIPacket, inputIStreamCoder, outputIStreamCoder, this._outputIContainer, inputIPacket.getSize(), previousPacketSize, streamIndex, timeStampOffset);
            } else if (inputIStreamCoder.getCodecType() == ICodec.Type.CODEC_TYPE_VIDEO) {
                if (this.isStartDecoding(inputIPacket, inputIStreamCoder, keyPacketFound = this.isKeyPacketFound(inputIPacket, keyPacketFound), nonkeyAfterKeyCount = this.countNonKeyAfterKey(inputIPacket, keyPacketFound, nonkeyAfterKeyCount), onlyDecodeKeyPackets)) {
                    int value = this.decodeVideo(iVideoResamplers[streamIndex], inputIVideoPictures[streamIndex], outputIVideoPictures[streamIndex], inputIPacket, outputIPacket, inputIStreamCoder, outputIStreamCoder, this._outputIContainer, null, null, 0, 0, timeStampOffset);
                    if (value <= 0) {
                        if (inputIPacket.isKey()) {
                            throw new RuntimeException("Unable to decode video stream " + streamIndex);
                        }
                        onlyDecodeKeyPackets = true;
                        continue;
                    }
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Do not decode video stream " + streamIndex));
                }
            }
            previousPacketSize = inputIPacket.getSize();
        }
        this.flush(outputIStreamCoders, this._outputIContainer);
        if (this._outputIContainer.writeTrailer() < 0) {
            throw new RuntimeException("Unable to write trailer to output file");
        }
        this.cleanUp((RefCounted[])iAudioResamplers, (RefCounted[])iVideoResamplers);
        this.cleanUp((RefCounted[])inputIAudioSamples, (RefCounted[])outputIAudioSamples);
        this.cleanUp((RefCounted[])inputIVideoPictures, (RefCounted[])outputIVideoPictures);
        this.cleanUp(inputIStreamCoders, outputIStreamCoders);
        this.cleanUp(inputIPacket, outputIPacket);
    }

    @Override
    protected IContainer getInputIContainer() {
        return this._inputIContainer;
    }

    protected int getVideoBitRate(int originalBitRate) {
        return this.getProperty(originalBitRate, this._videoBitRate, 1200000);
    }

    protected ICodec getVideoEncodingICodec(ICodec.Type inputICodecType, String outputURL) {
        IContainerFormat iContainerFormat = this._outputIContainer.getContainerFormat();
        String outputFormat = iContainerFormat.getOutputFormatShortName();
        if (outputFormat.equals("mp4")) {
            return ICodec.findEncodingCodec((ICodec.ID)ICodec.ID.CODEC_ID_H264);
        }
        return ICodec.guessEncodingCodec(null, null, (String)outputURL, null, (ICodec.Type)inputICodecType);
    }

    protected IRational getVideoFrameRate(IRational originalFrameRate) {
        if (this._videoFrameRate != null) {
            originalFrameRate = this._videoFrameRate;
        }
        return originalFrameRate;
    }

    protected void initVideoBitRate(Properties videoProperties) {
        this._videoBitRate = this.getProperty(videoProperties, "dl.file.entry.preview.video.bit.rate", "video bit rate", this._videoContainer, 250000, 1200000);
    }

    protected void initVideoFrameRate(Properties videoProperties) {
        int numerator = GetterUtil.getInteger((String)videoProperties.getProperty(StringBundler.concat((String[])new String[]{"dl.file.entry.preview.video.frame.rate.numerator", "[", this._videoContainer, "]"})));
        int denominator = GetterUtil.getInteger((String)videoProperties.getProperty(StringBundler.concat((String[])new String[]{"dl.file.entry.preview.video.frame.rate.denominator", "[", this._videoContainer, "]"})));
        if (numerator > 0 && denominator > 0) {
            this._videoFrameRate = IRational.make((int)numerator, (int)denominator);
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Default frame rate for ", this._videoContainer, " configured to ", this._videoFrameRate.getNumerator(), "/", this._videoFrameRate.getDenominator()}));
            }
        }
    }

    protected void prepareVideo(IVideoResampler[] iVideoResamplers, IVideoPicture[] inputIVideoPictures, IVideoPicture[] outputIVideoPictures, IStreamCoder inputIStreamCoder, IStreamCoder[] outputIStreamCoders, IContainer outputIContainer, IStream[] outputIStreams, ICodec.Type inputICodecType, String outputURL, int index) throws Exception {
        IStreamCoder outputIStreamCoder;
        IStream outputIStream;
        ICodec iCodec = this.getVideoEncodingICodec(inputICodecType, outputURL);
        if (iCodec == null) {
            throw new RuntimeException(StringBundler.concat((Object[])new Object[]{"Unable to determine ", inputICodecType, " encoder for ", outputURL}));
        }
        outputIStreams[index] = outputIStream = outputIContainer.addNewStream(iCodec);
        outputIStreamCoders[index] = outputIStreamCoder = outputIStream.getStreamCoder();
        int bitRate = inputIStreamCoder.getBitRate();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Original video bitrate " + bitRate));
        }
        bitRate = this.getVideoBitRate(bitRate);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Modified video bitrate " + bitRate));
        }
        outputIStreamCoder.setBitRate(bitRate);
        IRational iRational = inputIStreamCoder.getFrameRate();
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Original frame rate ", iRational.getNumerator(), "/", iRational.getDenominator()}));
        }
        iRational = this.getVideoFrameRate(iRational);
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Modified frame rate ", iRational.getNumerator(), "/", iRational.getDenominator()}));
        }
        outputIStreamCoder.setFrameRate(iRational);
        this._computeDimensions(inputIStreamCoder, outputIStreamCoder);
        outputIStreamCoder.setPixelType(IPixelFormat.Type.YUV420P);
        outputIStreamCoder.setTimeBase(IRational.make((int)iRational.getDenominator(), (int)iRational.getNumerator()));
        iVideoResamplers[index] = this.createIVideoResampler(inputIStreamCoder, outputIStreamCoder, this._height, this._width);
        inputIVideoPictures[index] = IVideoPicture.make((IPixelFormat.Type)inputIStreamCoder.getPixelType(), (int)inputIStreamCoder.getWidth(), (int)inputIStreamCoder.getHeight());
        outputIVideoPictures[index] = IVideoPicture.make((IPixelFormat.Type)outputIStreamCoder.getPixelType(), (int)outputIStreamCoder.getWidth(), (int)outputIStreamCoder.getHeight());
        ICodec.ID iCodecID = iCodec.getID();
        if (iCodecID.equals((Object)ICodec.ID.CODEC_ID_H264)) {
            Configuration.configure((Properties)this._ffpresetProperties, (IConfigurable)outputIStreamCoder);
        }
    }

    private void _computeDimensions(IStreamCoder inputIStreamCoder, IStreamCoder outputIStreamCoder) {
        if (inputIStreamCoder.getHeight() <= 0) {
            throw new RuntimeException("Unable to determine height for " + this._inputURL);
        }
        if (inputIStreamCoder.getWidth() <= 0) {
            throw new RuntimeException("Unable to determine width for " + this._inputURL);
        }
        double aspectRatio = (double)inputIStreamCoder.getWidth() / (double)inputIStreamCoder.getHeight();
        if (inputIStreamCoder.getWidth() > inputIStreamCoder.getHeight()) {
            this._width = this._width == 0 ? inputIStreamCoder.getWidth() : Math.min(inputIStreamCoder.getWidth(), this._width);
            this._height = this._height == 0 ? inputIStreamCoder.getHeight() : (int)Math.ceil((double)this._width / aspectRatio);
        } else {
            this._height = this._height == 0 ? inputIStreamCoder.getHeight() : Math.min(inputIStreamCoder.getHeight(), this._height);
            this._width = this._width == 0 ? inputIStreamCoder.getWidth() : (int)Math.ceil((double)this._height * aspectRatio);
        }
        double heightRatio = (double)this._height / (double)inputIStreamCoder.getHeight();
        double widthRatio = (double)this._width / (double)inputIStreamCoder.getWidth();
        if (heightRatio < 0.3333333333333333 || widthRatio < 0.3333333333333333) {
            this._height = (int)Math.ceil((double)inputIStreamCoder.getHeight() * 0.3333333333333333);
            this._width = (int)Math.ceil((double)inputIStreamCoder.getWidth() * 0.3333333333333333);
        }
        outputIStreamCoder.setHeight(this._height);
        outputIStreamCoder.setWidth(this._width);
    }
}

