/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.social.service.base.SocialActivityServiceBaseImpl;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import com.liferay.social.kernel.model.impl.SocialActivityInterpreterImpl;
import com.liferay.social.kernel.service.SocialActivityInterpreterLocalService;
import java.util.ArrayList;
import java.util.List;

public class SocialActivityServiceImpl
extends SocialActivityServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(SocialActivityServiceImpl.class);
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=SocialActivityInterpreterLocalService.class)
    private SocialActivityInterpreterLocalService _socialActivityInterpreterLocalService;

    public List<SocialActivity> getActivities(long classNameId, int start, int end) throws PortalException {
        List activities = this.socialActivityLocalService.getActivities(classNameId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    public List<SocialActivity> getActivities(long mirrorActivityId, long classNameId, long classPK, int start, int end) throws PortalException {
        List activities = this.socialActivityLocalService.getActivities(mirrorActivityId, classNameId, classPK, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    public List<SocialActivity> getActivities(long mirrorActivityId, String className, long classPK, int start, int end) throws PortalException {
        List activities = this.socialActivityLocalService.getActivities(mirrorActivityId, this._classNameLocalService.getClassNameId(className), classPK, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    public List<SocialActivity> getActivities(String className, int start, int end) throws PortalException {
        List activities = this.socialActivityLocalService.getActivities(this._classNameLocalService.getClassNameId(className), 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    public int getActivitiesCount(long classNameId) {
        return this.socialActivityLocalService.getActivitiesCount(classNameId);
    }

    public int getActivitiesCount(long mirrorActivityId, long classNameId, long classPK) {
        return this.socialActivityLocalService.getActivitiesCount(mirrorActivityId, classNameId, classPK);
    }

    public int getActivitiesCount(long mirrorActivityId, String className, long classPK) {
        return this.getActivitiesCount(mirrorActivityId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    public int getActivitiesCount(String className) {
        return this.getActivitiesCount(this._classNameLocalService.getClassNameId(className));
    }

    public SocialActivity getActivity(long activityId) throws PortalException {
        List activityInterpreters;
        SocialActivity activity = this.socialActivityLocalService.getActivity(activityId);
        if (!this.hasPermission(activity, activityInterpreters = this._socialActivityInterpreterLocalService.getActivityInterpreters(""))) {
            throw new PrincipalException.MustHavePermission(0L, SocialActivity.class.getName(), activityId, new String[0]);
        }
        return activity;
    }

    public List<SocialActivity> getActivitySetActivities(long activitySetId, int start, int end) throws PortalException {
        List activities = this.socialActivityLocalService.getActivitySetActivities(activitySetId, start, end);
        return this.filterActivities(activities, start, end);
    }

    public List<SocialActivity> getGroupActivities(long groupId, int start, int end) throws PortalException {
        List activities = this.socialActivityLocalService.getGroupActivities(groupId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    public int getGroupActivitiesCount(long groupId) {
        return this.socialActivityLocalService.getGroupActivitiesCount(groupId);
    }

    public List<SocialActivity> getGroupUsersActivities(long groupId, int start, int end) throws PortalException {
        List activities = this.socialActivityLocalService.getGroupUsersActivities(groupId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    public int getGroupUsersActivitiesCount(long groupId) {
        return this.socialActivityLocalService.getGroupUsersActivitiesCount(groupId);
    }

    public SocialActivity getMirrorActivity(long mirrorActivityId) throws PortalException {
        List activityInterpreters;
        SocialActivity activity = this.socialActivityLocalService.getMirrorActivity(mirrorActivityId);
        if (!this.hasPermission(activity, activityInterpreters = this._socialActivityInterpreterLocalService.getActivityInterpreters(""))) {
            throw new PrincipalException.MustHavePermission(0L, SocialActivity.class.getName(), mirrorActivityId, new String[0]);
        }
        return activity;
    }

    public List<SocialActivity> getOrganizationActivities(long organizationId, int start, int end) throws PortalException {
        List activities = this.socialActivityLocalService.getOrganizationActivities(organizationId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    public int getOrganizationActivitiesCount(long organizationId) {
        return this.socialActivityLocalService.getOrganizationActivitiesCount(organizationId);
    }

    public List<SocialActivity> getOrganizationUsersActivities(long organizationId, int start, int end) throws PortalException {
        List activities = this.socialActivityLocalService.getOrganizationUsersActivities(organizationId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    public int getOrganizationUsersActivitiesCount(long organizationId) {
        return this.socialActivityLocalService.getOrganizationUsersActivitiesCount(organizationId);
    }

    public List<SocialActivity> getRelationActivities(long userId, int start, int end) throws PortalException {
        List activities = this.socialActivityLocalService.getRelationActivities(userId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    public List<SocialActivity> getRelationActivities(long userId, int type, int start, int end) throws PortalException {
        List activities = this.socialActivityLocalService.getRelationActivities(userId, type, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    public int getRelationActivitiesCount(long userId) {
        return this.socialActivityLocalService.getRelationActivitiesCount(userId);
    }

    public int getRelationActivitiesCount(long userId, int type) {
        return this.socialActivityLocalService.getRelationActivitiesCount(userId, type);
    }

    public List<SocialActivity> getUserActivities(long userId, int start, int end) throws PortalException {
        List activities = this.socialActivityLocalService.getUserActivities(userId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    public int getUserActivitiesCount(long userId) {
        return this.socialActivityLocalService.getUserActivitiesCount(userId);
    }

    public List<SocialActivity> getUserGroupsActivities(long userId, int start, int end) throws PortalException {
        List activities = this.socialActivityLocalService.getUserGroupsActivities(userId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    public int getUserGroupsActivitiesCount(long userId) {
        return this.socialActivityLocalService.getUserGroupsActivitiesCount(userId);
    }

    public List<SocialActivity> getUserGroupsAndOrganizationsActivities(long userId, int start, int end) throws PortalException {
        List activities = this.socialActivityLocalService.getUserGroupsAndOrganizationsActivities(userId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    public int getUserGroupsAndOrganizationsActivitiesCount(long userId) {
        return this.socialActivityLocalService.getUserGroupsAndOrganizationsActivitiesCount(userId);
    }

    public List<SocialActivity> getUserOrganizationsActivities(long userId, int start, int end) throws PortalException {
        List activities = this.socialActivityLocalService.getUserOrganizationsActivities(userId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    public int getUserOrganizationsActivitiesCount(long userId) {
        return this.socialActivityLocalService.getUserOrganizationsActivitiesCount(userId);
    }

    protected List<SocialActivity> filterActivities(List<SocialActivity> activities, int start, int end) throws PortalException {
        List<Object> filteredActivities = new ArrayList<SocialActivity>();
        List activityInterpreters = this._socialActivityInterpreterLocalService.getActivityInterpreters("");
        for (SocialActivity activity : activities) {
            if (this.hasPermission(activity, activityInterpreters)) {
                filteredActivities.add(activity);
            }
            if (end == -1 || filteredActivities.size() <= end) continue;
            break;
        }
        if (end != -1 && start != -1) {
            if (end > filteredActivities.size()) {
                end = filteredActivities.size();
            }
            if (start > filteredActivities.size()) {
                start = filteredActivities.size();
            }
            filteredActivities = filteredActivities.subList(start, end);
        }
        return filteredActivities;
    }

    protected boolean hasPermission(SocialActivity activity, List<SocialActivityInterpreter> activityInterpreters) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        ServiceContext serviceContext = new ServiceContext();
        for (SocialActivityInterpreter activityInterpreter : activityInterpreters) {
            SocialActivityInterpreterImpl socialActivityInterpreterImpl = (SocialActivityInterpreterImpl)activityInterpreter;
            if (!socialActivityInterpreterImpl.hasClassName(activity.getClassName())) continue;
            try {
                if (!socialActivityInterpreterImpl.hasPermission(permissionChecker, activity, "VIEW", serviceContext)) continue;
                return true;
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        return false;
    }
}

