/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usergroupsadmin.search;

import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.usergroupsadmin.search.UserGroupDisplayTerms;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class UserGroupSearch
extends SearchContainer<UserGroup> {
    public static final String EMPTY_RESULTS_MESSAGE = "no-user-groups-were-found";
    public static List<String> headerNames = new ArrayList<String>(){
        {
            this.add("name");
            this.add("description");
        }
    };
    public static Map<String, String> orderableHeaders = HashMapBuilder.put((Object)"description", (Object)"description").put((Object)"name", (Object)"name").build();
    private static final Log _log = LogFactoryUtil.getLog(UserGroupSearch.class);

    public UserGroupSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        super(portletRequest, (DisplayTerms)new UserGroupDisplayTerms(portletRequest), (DisplayTerms)new UserGroupDisplayTerms(portletRequest), "cur", DEFAULT_DELTA, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        UserGroupDisplayTerms displayTerms = (UserGroupDisplayTerms)this.getDisplayTerms();
        iteratorURL.setParameter("description", displayTerms.getDescription());
        iteratorURL.setParameter("name", displayTerms.getName());
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)portletRequest);
            String orderByCol = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByCol");
            String orderByType = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByType");
            String portletId = PortletProviderUtil.getPortletId((String)User.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
            if (Validator.isNotNull((String)orderByCol) && Validator.isNotNull((String)orderByType)) {
                preferences.setValue(portletId, "user-groups-order-by-col", orderByCol);
                preferences.setValue(portletId, "user-groups-order-by-type", orderByType);
            } else {
                orderByCol = preferences.getValue(portletId, "user-groups-order-by-col", "name");
                orderByType = preferences.getValue(portletId, "user-groups-order-by-type", "asc");
            }
            OrderByComparator orderByComparator = UsersAdminUtil.getUserGroupOrderByComparator((String)orderByCol, (String)orderByType);
            this.setOrderableHeaders(orderableHeaders);
            this.setOrderByCol(orderByCol);
            this.setOrderByType(orderByType);
            this.setOrderByComparator(orderByComparator);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to initialize user group search", (Throwable)exception);
        }
    }
}

