/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.asm;

import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMUtil {
    private static final MethodVisitor _emptyMethodVisitor = new MethodVisitor(327680){};

    public static void addDefaultReturnInsns(MethodVisitor methodVisitor, Type returnType) {
        int sort = returnType.getSort();
        if (sort == 1 || sort == 2 || sort == 3 || sort == 5 || sort == 4) {
            methodVisitor.visitInsn(3);
            methodVisitor.visitInsn(172);
        } else if (sort == 8) {
            methodVisitor.visitInsn(14);
            methodVisitor.visitInsn(175);
        } else if (sort == 6) {
            methodVisitor.visitInsn(11);
            methodVisitor.visitInsn(174);
        } else if (sort == 7) {
            methodVisitor.visitInsn(9);
            methodVisitor.visitInsn(173);
        } else if (sort == 0) {
            methodVisitor.visitInsn(177);
        } else {
            methodVisitor.visitInsn(1);
            methodVisitor.visitInsn(176);
        }
    }

    public static List<FieldNode> addFieldNodes(List<FieldNode> fieldNodes, List<FieldNode> newFieldNodes) {
        ArrayList<FieldNode> addedFieldNodes = new ArrayList<FieldNode>();
        block0: for (FieldNode newFieldNode : newFieldNodes) {
            String newFieldNodeName = newFieldNode.name;
            for (FieldNode fieldNode : fieldNodes) {
                if (!newFieldNodeName.equals(fieldNode.name)) continue;
                continue block0;
            }
            addedFieldNodes.add(newFieldNode);
        }
        fieldNodes.addAll(addedFieldNodes);
        return addedFieldNodes;
    }

    public static FieldNode findFieldNode(List<FieldNode> fieldNodes, String name) {
        for (FieldNode fieldNode : fieldNodes) {
            if (!name.equals(fieldNode.name)) continue;
            return fieldNode;
        }
        return null;
    }

    public static MethodNode findMethodNode(List<MethodNode> methodNodes, String name, Type returnType, Type ... argumentTypes) {
        String desc = Type.getMethodDescriptor((Type)returnType, (Type[])argumentTypes);
        for (MethodNode methodNode : methodNodes) {
            if (!name.equals(methodNode.name) || !desc.equals(methodNode.desc)) continue;
            return methodNode;
        }
        return null;
    }

    public static ClassNode loadAndRename(Class<?> clazz, String newName) {
        ClassLoader classLoader = clazz.getClassLoader();
        String name = clazz.getName();
        name = StringUtil.replace((String)name, (char)'.', (char)'/');
        ClassReader classReader = null;
        try {
            classReader = new ClassReader(classLoader.getResourceAsStream(name.concat(".class")));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        ClassNode classNode = new ClassNode();
        RemappingClassAdapter classVisitor = new RemappingClassAdapter((ClassVisitor)classNode, new RenameClassRemapper(name, newName)){

            public void visitInnerClass(String name, String outerName, String innerName, int access) {
            }
        };
        classReader.accept((ClassVisitor)classVisitor, 6);
        return classNode;
    }

    public static void mergeMethods(MethodNode containerMethodNode, MethodNode headMethodNode, MethodNode tailMethodNode) {
        final MethodNode methodNode = new MethodNode();
        headMethodNode.accept((MethodVisitor)new AdviceAdapter(327680, (MethodVisitor)methodNode, headMethodNode.access, headMethodNode.name, headMethodNode.desc){

            protected void onMethodExit(int opcode) {
                this.mv = _emptyMethodVisitor;
            }
        });
        tailMethodNode.accept((MethodVisitor)new AdviceAdapter(327680, _emptyMethodVisitor, tailMethodNode.access, tailMethodNode.name, tailMethodNode.desc){

            protected void onMethodEnter() {
                this.mv = methodNode;
            }
        });
        containerMethodNode.instructions = methodNode.instructions;
    }

    public static MethodNode removeMethodNode(List<MethodNode> methodNodes, String name, Type returnType, Type ... argumentTypes) {
        String desc = Type.getMethodDescriptor((Type)returnType, (Type[])argumentTypes);
        for (MethodNode methodNode : methodNodes) {
            if (!name.equals(methodNode.name) || !desc.equals(methodNode.desc)) continue;
            methodNodes.remove(methodNode);
            return methodNode;
        }
        return null;
    }

    public static List<MethodNode> removeMethodNodes(List<MethodNode> methodNodes, int access) {
        ArrayList<MethodNode> removedMethodNodes = new ArrayList<MethodNode>();
        for (MethodNode methodNode : methodNodes) {
            if ((access & methodNode.access) == 0) continue;
            removedMethodNodes.add(methodNode);
        }
        methodNodes.removeAll(removedMethodNodes);
        return removedMethodNodes;
    }

    public static List<MethodNode> removeMethodNodes(List<MethodNode> methodNodes, Set<String> annotations) {
        ArrayList<MethodNode> removedMethodNodes = new ArrayList<MethodNode>();
        block0: for (MethodNode methodNode : methodNodes) {
            List annotationNodes = methodNode.visibleAnnotations;
            if (annotationNodes == null) continue;
            for (AnnotationNode annotationNode : annotationNodes) {
                if (!annotations.contains(annotationNode.desc)) continue;
                removedMethodNodes.add(methodNode);
                continue block0;
            }
        }
        methodNodes.removeAll(removedMethodNodes);
        return removedMethodNodes;
    }

    public static List<MethodNode> removeMethodNodes(List<MethodNode> methodNodes, String name) {
        ArrayList<MethodNode> removedMethodNodes = new ArrayList<MethodNode>();
        for (MethodNode methodNode : methodNodes) {
            if (!name.equals(methodNode.name)) continue;
            removedMethodNodes.add(methodNode);
        }
        methodNodes.removeAll(removedMethodNodes);
        return removedMethodNodes;
    }

    private static class RenameClassRemapper
    extends Remapper {
        private final String _newClassName;
        private final String _oldClassName;

        public RenameClassRemapper(String oldClassName, String newClassName) {
            this._oldClassName = oldClassName;
            this._newClassName = newClassName;
        }

        public String map(String typeName) {
            if (typeName.equals(this._oldClassName)) {
                return this._newClassName;
            }
            return typeName;
        }
    }
}

